/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.ArtifactResponse;

public class NameIDFormatAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public NameIDFormatAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject msg = (SAMLObject)this.responseLookupStrategy.apply((Object)input);
        if (msg != null) {
            if (msg instanceof ArtifactResponse) {
                msg = ((ArtifactResponse)msg).getMessage();
            }
            if (msg instanceof org.opensaml.saml.saml2.core.Response) {
                for (org.opensaml.saml.saml2.core.Assertion assertion : ((org.opensaml.saml.saml2.core.Response)msg).getAssertions()) {
                    String format = this.apply(assertion);
                    if (format == null) continue;
                    return format;
                }
            } else if (msg instanceof Response) {
                for (Assertion assertion : ((Response)msg).getAssertions()) {
                    String format = this.apply(assertion);
                    if (format == null) continue;
                    return format;
                }
            } else {
                if (msg instanceof org.opensaml.saml.saml2.core.Assertion) {
                    return this.apply((org.opensaml.saml.saml2.core.Assertion)msg);
                }
                if (msg instanceof Assertion) {
                    return this.apply((Assertion)msg);
                }
            }
        }
        return null;
    }

    @Nullable
    private String apply(@Nonnull org.opensaml.saml.saml2.core.Assertion assertion) {
        if (assertion.getSubject() != null && assertion.getSubject().getNameID() != null) {
            return assertion.getSubject().getNameID().getFormat();
        }
        return null;
    }

    @Nullable
    private String apply(@Nonnull Assertion assertion) {
        for (AuthenticationStatement statement : assertion.getAuthenticationStatements()) {
            if (statement.getSubject() == null || statement.getSubject().getNameIdentifier() == null) continue;
            return statement.getSubject().getNameIdentifier().getFormat();
        }
        for (AuthenticationStatement statement : assertion.getAttributeStatements()) {
            if (statement.getSubject() == null || statement.getSubject().getNameIdentifier() == null) continue;
            return statement.getSubject().getNameIdentifier().getFormat();
        }
        for (AuthenticationStatement statement : assertion.getAuthorizationDecisionStatements()) {
            if (statement.getSubject() == null || statement.getSubject().getNameIdentifier() == null) continue;
            return statement.getSubject().getNameIdentifier().getFormat();
        }
        for (AuthenticationStatement statement : assertion.getSubjectStatements()) {
            if (statement.getSubject() == null || statement.getSubject().getNameIdentifier() == null) continue;
            return statement.getSubject().getNameIdentifier().getFormat();
        }
        return null;
    }
}

