/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.session.SAML1SPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1SPSessionCreationStrategy
implements Function<ProfileRequestContext, SPSession> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1SPSessionCreationStrategy.class);
    @Duration
    @Positive
    private final long sessionLifetime;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;

    public SAML1SPSessionCreationStrategy(@Duration @Positive long lifetime) {
        this.sessionLifetime = Constraint.isGreaterThan((long)0L, (long)lifetime, (String)"Lifetime must be greater than 0");
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nullable
    public SPSession apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpCtx = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)input);
        if (rpCtx == null) {
            this.log.debug("No RelyingPartyContext, no SPSession created");
            return null;
        }
        String issuer = rpCtx.getRelyingPartyId();
        if (issuer == null) {
            this.log.debug("No relying party ID, no SPSession created");
            return null;
        }
        long now = System.currentTimeMillis();
        return new SAML1SPSession(issuer, now, now + this.sessionLifetime);
    }
}

