/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.saml.attribute.resolver.impl.AbstractPersistentIdDataConnector;
import net.shibboleth.idp.saml.nameid.impl.ComputedPersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedIDDataConnector
extends AbstractPersistentIdDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ComputedIDDataConnector.class);
    @Nullable
    private ComputedPersistentIdGenerationStrategy idStrategy = new ComputedPersistentIdGenerationStrategy();

    @Nullable
    public ComputedPersistentIdGenerationStrategy getComputedIdStrategy() {
        return this.idStrategy;
    }

    @Nullable
    protected void clearComputedIdStrategy() {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStrategy = null;
    }

    @Nullable
    public byte[] getSalt() {
        if (null == this.idStrategy) {
            return null;
        }
        return this.idStrategy.getSalt();
    }

    public void setSalt(@Nullable byte[] salt) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (null != salt) {
            this.log.debug("{} Salt set (secret is logged at TRACE)", (Object)this.getLogPrefix());
            this.log.trace("{} Salt set as bytes to {}", (Object)this.getLogPrefix(), (Object)Arrays.toString(salt));
            this.idStrategy.setSalt(salt);
        } else {
            this.log.debug("{} Null salt passed, nothing set", (Object)this.getLogPrefix());
        }
    }

    public void setSalt(@Nullable String salt) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (null != salt) {
            this.setSalt(salt.getBytes());
        } else {
            this.log.debug("{} Null salt passed, nothing set", (Object)this.getLogPrefix());
        }
    }

    @Nullable
    @NotEmpty
    public String getAlgorithm() {
        if (null == this.idStrategy) {
            return null;
        }
        return this.idStrategy.getAlgorithm();
    }

    public void setAlgorithm(@Nonnull @NotEmpty String alg) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStrategy.setAlgorithm(alg);
    }

    @Nullable
    public ComputedPersistentIdGenerationStrategy.Encoding getEncoding() {
        if (null == this.idStrategy) {
            return null;
        }
        return this.idStrategy.getEncoding();
    }

    public void setEncoding(@Nonnull ComputedPersistentIdGenerationStrategy.Encoding enc) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStrategy.setEncoding(enc);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null != this.idStrategy) {
            this.idStrategy.initialize();
        }
    }

    protected void doDestroy() {
        if (null != this.idStrategy) {
            this.idStrategy.destroy();
        }
        super.doDestroy();
    }

    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (null == this.idStrategy) {
            this.log.error("{} Resolve called for seedless stored ID", (Object)this.getLogPrefix());
            throw new ResolutionException(this.getLogPrefix() + " Resolve called for seedless stored ID");
        }
        String principalName = resolutionContext.getPrincipal();
        if (Strings.isNullOrEmpty((String)principalName)) {
            this.log.warn("{} No principal name located, unable to compute ID", (Object)this.getLogPrefix());
            return null;
        }
        String attributeIssuerId = resolutionContext.getAttributeIssuerID();
        if (Strings.isNullOrEmpty((String)attributeIssuerId)) {
            this.log.warn("{} No Attribute issuer ID located, unable to compute ID", (Object)this.getLogPrefix());
            return null;
        }
        String attributeRecipientID = resolutionContext.getAttributeRecipientGroupID();
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            attributeRecipientID = resolutionContext.getAttributeRecipientID();
        }
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            this.log.warn("{} No Attribute recipient or group ID located, unable to compute ID", (Object)this.getLogPrefix());
            return null;
        }
        String sourceId = this.resolveSourceAttribute(workContext);
        if (Strings.isNullOrEmpty((String)sourceId)) {
            return null;
        }
        try {
            return this.encodeAsAttribute(this.idStrategy.generate(attributeIssuerId, attributeRecipientID, principalName, sourceId));
        }
        catch (SAMLException e) {
            throw new ResolutionException((Exception)((Object)e));
        }
    }
}

