/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.saml.nameid.PersistentIdEntry;
import net.shibboleth.idp.saml.nameid.impl.ComputedPersistentIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.PersistentIdStoreEx;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPersistentIdStoreEx
extends AbstractInitializableComponent
implements PersistentIdStoreEx {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JDBCPersistentIdStoreEx.class);
    @NonnullAfterInit
    private DataSource dataSource;
    @Duration
    @NonNegative
    private long queryTimeout = 5000L;
    @NonNegative
    private int transactionRetry = 3;
    @Nonnull
    @NonnullElements
    private Collection<String> retryableErrors = Arrays.asList("23000", "23505");
    private boolean verifyDatabase = true;
    @Nonnull
    @NotEmpty
    private String tableName = "shibpid";
    @Nonnull
    @NotEmpty
    private String issuerColumn = "localEntity";
    @Nonnull
    @NotEmpty
    private String recipientColumn = "peerEntity";
    @Nonnull
    @NotEmpty
    private String principalNameColumn = "principalName";
    @Nonnull
    @NotEmpty
    private String sourceIdColumn = "localId";
    @Nonnull
    @NotEmpty
    private String persistentIdColumn = "persistentId";
    @Nonnull
    @NotEmpty
    private String peerProvidedIdColumn = "peerProvidedId";
    @Nonnull
    @NotEmpty
    private String creationTimeColumn = "creationDate";
    @Nonnull
    @NotEmpty
    private String deactivationTimeColumn = "deactivationDate";
    @NonnullAfterInit
    private String getByIssuedSelectSQL;
    @NonnullAfterInit
    private String getBySourceSelectSQL;
    @NonnullAfterInit
    private String insertSQL;
    @NonnullAfterInit
    private String deactivateSQL;
    @NonnullAfterInit
    private String attachSQL;
    @NonnullAfterInit
    private String deleteSQL;

    @NonnullAfterInit
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@Nonnull DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"DataSource cannot be null");
    }

    @Duration
    @NonNegative
    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    @Duration
    public void setQueryTimeout(@Duration @NonNegative long timeout) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.queryTimeout = Constraint.isGreaterThanOrEqual((long)0L, (long)timeout, (String)"Timeout must be greater than or equal to 0");
    }

    public int getTransactionRetries() {
        return this.transactionRetry;
    }

    public void setTransactionRetries(@NonNegative int retries) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transactionRetry = (int)Constraint.isGreaterThanOrEqual((long)0L, (long)retries, (String)"Timeout must be greater than or equal to 0");
    }

    @Nonnull
    @NonnullElements
    public Collection<String> getRetryableErrors() {
        return this.retryableErrors;
    }

    public void setRetryableErrors(@Nullable @NonnullElements Collection<String> errors) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.retryableErrors = new ArrayList<String>(StringSupport.normalizeStringCollection(errors));
    }

    public boolean getVerifyDatabase() {
        return this.verifyDatabase;
    }

    public void setVerifyDatabase(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.verifyDatabase = flag;
    }

    public void setTableName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tableName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Table name cannot be null or empty");
    }

    public void setLocalEntityColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPeerEntityColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.recipientColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPrincipalNameColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalNameColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setSourceIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sourceIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPersistentIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.persistentIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPeerProvidedIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.peerProvidedIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setCreateTimeColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.creationTimeColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setDeactivationTimeColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deactivationTimeColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setGetByIssuedSelectSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.getByIssuedSelectSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setGetBySourceSelectSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.getBySourceSelectSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setInsertSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.insertSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setDeactivateSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deactivateSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setAttachSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attachSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setDeleteSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deleteSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSource) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No database connection provided");
        }
        if (this.getByIssuedSelectSQL == null) {
            this.getByIssuedSelectSQL = "SELECT * FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ? AND " + this.deactivationTimeColumn + " IS NULL";
        }
        if (this.getBySourceSelectSQL == null) {
            this.getBySourceSelectSQL = "SELECT * FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.sourceIdColumn + "= ? " + "AND (" + this.deactivationTimeColumn + " IS NULL OR " + this.deactivationTimeColumn + " = (SELECT MAX(" + this.deactivationTimeColumn + ") FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.sourceIdColumn + "= ?)) ORDER BY " + this.creationTimeColumn + " DESC";
        }
        if (this.insertSQL == null) {
            this.insertSQL = "INSERT INTO " + this.tableName + " (" + this.issuerColumn + ", " + this.recipientColumn + ", " + this.persistentIdColumn + ", " + this.principalNameColumn + ", " + this.sourceIdColumn + ", " + this.peerProvidedIdColumn + ", " + this.creationTimeColumn + ", " + this.deactivationTimeColumn + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        }
        if (this.deactivateSQL == null) {
            this.deactivateSQL = "UPDATE " + this.tableName + " SET " + this.deactivationTimeColumn + "= ? WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ?";
        }
        if (this.attachSQL == null) {
            this.attachSQL = "UPDATE " + this.tableName + " SET " + this.peerProvidedIdColumn + "= ? WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ?";
        }
        if (this.deleteSQL == null) {
            this.deleteSQL = "DELETE FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ?";
        }
        try {
            this.verifyDatabase();
            this.log.info("{} Data source successfully verified", (Object)this.getLogPrefix());
        }
        catch (SQLException e) {
            if (this.verifyDatabase) {
                this.log.error("{} Exception verifying database", (Object)this.getLogPrefix(), (Object)e);
                throw new ComponentInitializationException("The database was not reachable or was not defined with an appropriate table + primary key");
            }
            this.log.warn("{} The database was not reachable or was not defined with an appropriate table + primary key", (Object)this.getLogPrefix(), (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public PersistentIdEntry getByIssuedValue(@Nonnull @NotEmpty String nameQualifier, @Nonnull @NotEmpty String spNameQualifier, @Nonnull @NotEmpty String persistentId) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        this.log.debug("{} Selecting previously issued persistent ID entry", (Object)this.getLogPrefix(), (Object)this.getByIssuedSelectSQL);
        this.log.trace("{} Prepared statement: {}", (Object)this.getLogPrefix(), (Object)this.getByIssuedSelectSQL);
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, nameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 2, spNameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 3, persistentId});
        try (Connection dbConn = this.getConnection(true);){
            PreparedStatement statement = dbConn.prepareStatement(this.getByIssuedSelectSQL);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            statement.setString(1, nameQualifier);
            statement.setString(2, spNameQualifier);
            statement.setString(3, persistentId);
            List<PersistentIdEntry> entries = this.buildIdentifierEntries(statement.executeQuery());
            if (entries == null || entries.size() == 0) {
                PersistentIdEntry persistentIdEntry = null;
                return persistentIdEntry;
            }
            if (entries.size() > 1) {
                this.log.warn("{} More than one record found, only the first will be returned", (Object)this.getLogPrefix());
            }
            PersistentIdEntry persistentIdEntry = entries.get(0);
            return persistentIdEntry;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public PersistentIdEntry getBySourceValue(@Nonnull @NotEmpty String nameQualifier, @Nonnull @NotEmpty String spNameQualifier, @Nonnull @NotEmpty String sourceId, @Nonnull @NotEmpty String principal, boolean allowCreate, @Nullable ComputedPersistentIdGenerationStrategy computedIdStrategy) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        this.log.debug("{} Obtaining persistent ID for source ID: {}", (Object)this.getLogPrefix(), (Object)sourceId);
        this.log.trace("{} Prepared statement: {}", (Object)this.getLogPrefix(), (Object)this.getBySourceSelectSQL);
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, nameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 2, spNameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 3, sourceId});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 4, nameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 5, spNameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 6, sourceId});
        int retries = this.transactionRetry;
        while (true) {
            try (Connection dbConn = this.getConnection(false);){
                PreparedStatement statement = dbConn.prepareStatement(this.getBySourceSelectSQL);
                statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
                statement.setString(1, nameQualifier);
                statement.setString(2, spNameQualifier);
                statement.setString(3, sourceId);
                statement.setString(4, nameQualifier);
                statement.setString(5, spNameQualifier);
                statement.setString(6, sourceId);
                this.log.debug("{} Getting active and/or last inactive persistent Id entry", (Object)this.getLogPrefix());
                List<PersistentIdEntry> entries = this.buildIdentifierEntries(statement.executeQuery());
                if (entries != null && entries.size() > 0 && (entries.get(0).getDeactivationTime() == null || entries.get(0).getDeactivationTime().getTime() > System.currentTimeMillis())) {
                    this.log.debug("{} Returning existing active persistent ID: {}", (Object)this.getLogPrefix(), (Object)entries.get(0).getPersistentId());
                    dbConn.commit();
                    PersistentIdEntry persistentIdEntry = entries.get(0);
                    return persistentIdEntry;
                }
                if (!allowCreate) {
                    this.log.debug("{} No existing persistent ID and creation is not permitted", (Object)this.getLogPrefix());
                    dbConn.commit();
                    PersistentIdEntry persistentIdEntry = null;
                    return persistentIdEntry;
                }
                PersistentIdEntry newEntry = new PersistentIdEntry();
                newEntry.setIssuerEntityId(nameQualifier);
                newEntry.setRecipientEntityId(spNameQualifier);
                newEntry.setSourceId(sourceId);
                newEntry.setPrincipalName(principal);
                newEntry.setCreationTime(new Timestamp(System.currentTimeMillis()));
                if ((entries == null || entries.size() == 0) && computedIdStrategy != null) {
                    this.log.debug("{} Issuing new computed persistent ID", (Object)this.getLogPrefix());
                    newEntry.setPersistentId(computedIdStrategy.generate(nameQualifier, spNameQualifier, principal, sourceId));
                } else {
                    this.log.debug("{} Issuing new random persistent ID", (Object)this.getLogPrefix());
                    newEntry.setPersistentId(UUID.randomUUID().toString());
                    if (entries != null && entries.size() > 0) {
                        newEntry.setPeerProvidedId(entries.get(0).getPeerProvidedId());
                    }
                }
                this.store(newEntry, dbConn);
                dbConn.commit();
                PersistentIdEntry persistentIdEntry = newEntry;
                return persistentIdEntry;
            }
            catch (SQLException e) {
                boolean retry = false;
                for (String msg : this.retryableErrors) {
                    if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                    this.log.warn("{} Caught retryable SQL exception", (Object)this.getLogPrefix(), (Object)e);
                    retry = true;
                }
                if (!retry) throw new IOException(e);
                if (--retries < 0) {
                    this.log.warn("{} Error retryable, but retry limit exceeded", (Object)this.getLogPrefix());
                    throw new IOException(e);
                }
                this.log.info("{} Retrying persistent ID lookup/create operation", (Object)this.getLogPrefix());
                continue;
            }
            break;
        }
        catch (SAMLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deactivate(@Nonnull @NotEmpty String nameQualifier, @Nonnull @NotEmpty String spNameQualifier, @Nonnull @NotEmpty String persistentId, @Nullable DateTime deactivation) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Timestamp deactivationTime = deactivation == null ? new Timestamp(System.currentTimeMillis()) : new Timestamp(deactivation.getMillis());
        this.log.debug("Deactivating persistent id {} as of {}", (Object)persistentId, (Object)deactivationTime);
        this.log.trace("{} Prepared statement: {}", (Object)this.getLogPrefix(), (Object)this.deactivateSQL);
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, deactivationTime});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 2, nameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 3, spNameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 4, persistentId});
        try (Connection dbConn = this.getConnection(true);){
            PreparedStatement statement = dbConn.prepareStatement(this.deactivateSQL);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            statement.setTimestamp(1, deactivationTime);
            statement.setString(2, nameQualifier);
            statement.setString(3, spNameQualifier);
            statement.setString(4, persistentId);
            int rowCount = statement.executeUpdate();
            if (rowCount != 1) {
                this.log.warn("{} Unexpected result, statement affected {} rows", (Object)this.getLogPrefix(), (Object)rowCount);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void attach(@Nonnull @NotEmpty String nameQualifier, @Nonnull @NotEmpty String spNameQualifier, @Nonnull @NotEmpty String persistentId, @Nonnull @NotEmpty String spProvidedId) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        this.log.debug("Attaching SPProvidedID {} to persistent id {}", (Object)spProvidedId, (Object)persistentId);
        this.log.trace("{} Prepared statement: {}", (Object)this.getLogPrefix(), (Object)this.attachSQL);
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, spProvidedId});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 2, nameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 3, spNameQualifier});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 4, persistentId});
        try (Connection dbConn = this.getConnection(true);){
            PreparedStatement statement = dbConn.prepareStatement(this.deactivateSQL);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            statement.setString(1, spProvidedId);
            statement.setString(2, nameQualifier);
            statement.setString(3, spNameQualifier);
            statement.setString(4, persistentId);
            int rowCount = statement.executeUpdate();
            if (rowCount != 1) {
                this.log.warn("{} Unexpected result, statement affected {} rows", (Object)this.getLogPrefix(), (Object)rowCount);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void store(@Nonnull PersistentIdEntry entry, @Nonnull Connection dbConn) throws SQLException {
        this.log.debug("{} Storing new persistent ID entry", (Object)this.getLogPrefix());
        if (StringSupport.trimOrNull((String)entry.getIssuerEntityId()) == null || StringSupport.trimOrNull((String)entry.getRecipientEntityId()) == null || StringSupport.trimOrNull((String)entry.getPersistentId()) == null || StringSupport.trimOrNull((String)entry.getPrincipalName()) == null || StringSupport.trimOrNull((String)entry.getSourceId()) == null || entry.getCreationTime() == null) {
            throw new SQLException("Required field was empty/null, store operation not possible");
        }
        this.log.trace("{} Prepared statement: {}", (Object)this.getLogPrefix(), (Object)this.insertSQL);
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 1, entry.getIssuerEntityId()});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 2, entry.getRecipientEntityId()});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 3, entry.getPersistentId()});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 4, entry.getPrincipalName()});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 5, entry.getSourceId()});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 6, entry.getPeerProvidedId()});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 7, entry.getCreationTime()});
        this.log.trace("{} Setting prepared statement parameter {}: {}", new Object[]{this.getLogPrefix(), 8, entry.getDeactivationTime()});
        PreparedStatement statement = dbConn.prepareStatement(this.insertSQL);
        statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
        statement.setString(1, entry.getIssuerEntityId());
        statement.setString(2, entry.getRecipientEntityId());
        statement.setString(3, entry.getPersistentId());
        statement.setString(4, entry.getPrincipalName());
        statement.setString(5, entry.getSourceId());
        if (entry.getPeerProvidedId() != null) {
            statement.setString(6, entry.getPeerProvidedId());
        } else {
            statement.setNull(6, 12);
        }
        statement.setTimestamp(7, entry.getCreationTime());
        if (entry.getDeactivationTime() != null) {
            statement.setTimestamp(8, entry.getDeactivationTime());
        } else {
            statement.setNull(8, 93);
        }
        statement.executeUpdate();
    }

    @Nonnull
    private Connection getConnection(boolean autoCommit) throws SQLException {
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(autoCommit);
        conn.setTransactionIsolation(8);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDatabase() throws SQLException {
        Throwable throwable;
        Connection conn;
        String uuid = UUID.randomUUID().toString();
        PersistentIdEntry newEntry = new PersistentIdEntry();
        newEntry.setIssuerEntityId("http://dummy.com/idp/" + uuid);
        newEntry.setRecipientEntityId("http://dummy.com/sp/" + uuid);
        newEntry.setSourceId("dummy");
        newEntry.setPrincipalName("dummy");
        newEntry.setCreationTime(new Timestamp(System.currentTimeMillis()));
        newEntry.setPersistentId(uuid);
        try (Connection conn2 = this.getConnection(true);){
            this.store(newEntry, conn2);
        }
        boolean keyMissing = false;
        try {
            conn = this.getConnection(true);
            throwable = null;
            try {
                this.store(newEntry, conn);
                keyMissing = true;
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && !this.retryableErrors.contains(e.getSQLState())) {
                this.log.warn("{} Duplicate insert failed as required with SQL State '{}', ensure this value is configured as a retryable error", (Object)this.getLogPrefix(), (Object)e.getSQLState());
            }
        }
        conn = this.getConnection(true);
        throwable = null;
        try {
            PreparedStatement statement = conn.prepareStatement(this.deleteSQL);
            statement.setQueryTimeout((int)(this.queryTimeout / 1000L));
            statement.setString(1, "http://dummy.com/idp/" + uuid);
            statement.executeUpdate();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        if (keyMissing) {
            throw new SQLException("Duplicate insertion succeeded, primary key missing from table");
        }
    }

    @Nonnull
    @NonnullElements
    @Live
    private List<PersistentIdEntry> buildIdentifierEntries(@Nonnull ResultSet resultSet) throws SQLException {
        ArrayList<PersistentIdEntry> entries = new ArrayList<PersistentIdEntry>();
        while (resultSet.next()) {
            PersistentIdEntry entry = new PersistentIdEntry();
            entry.setIssuerEntityId(resultSet.getString(this.issuerColumn));
            entry.setRecipientEntityId(resultSet.getString(this.recipientColumn));
            entry.setPrincipalName(resultSet.getString(this.principalNameColumn));
            entry.setPersistentId(resultSet.getString(this.persistentIdColumn));
            entry.setSourceId(resultSet.getString(this.sourceIdColumn));
            entry.setPeerProvidedId(resultSet.getString(this.peerProvidedIdColumn));
            entry.setCreationTime(resultSet.getTimestamp(this.creationTimeColumn));
            entry.setDeactivationTime(resultSet.getTimestamp(this.deactivationTimeColumn));
            entries.add(entry);
            this.log.trace("{} Entry {} added to results", (Object)this.getLogPrefix(), (Object)entry.toString());
        }
        return entries;
    }

    @Nonnull
    @NotEmpty
    private String getLogPrefix() {
        return "Stored Id Store:";
    }
}

