/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.NameIdentifierGenerationService;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;

public class ProxySAML2NameIDGenerator
implements SAML2NameIDGenerator {
    @Nonnull
    private final ReloadableService<NameIdentifierGenerationService> generatorService;

    public ProxySAML2NameIDGenerator(@Nonnull ReloadableService<NameIdentifierGenerationService> service) {
        this.generatorService = (ReloadableService)Constraint.isNotNull(service, (String)"NameIdentifierGenerationService cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NameID generate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String format) throws SAMLException {
        ServiceableComponent component = null;
        try {
            component = this.generatorService.getServiceableComponent();
            if (component == null) {
                throw new SAMLException("Invalid NameIdentifierGenerationService configuration");
            }
            NameID nameID = ((NameIdentifierGenerationService)component.getComponent()).getSAML2NameIDGenerator().generate(profileRequestContext, format);
            return nameID;
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }
}

