/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import java.security.Principal;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.DefaultPrincipalDeterminationStrategy;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.profile.config.navigate.SessionLifetimeLookupFunction;
import net.shibboleth.idp.saml.profile.impl.BaseAddAuthenticationStatementToAssertion;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAuthnStatementToAssertion
extends BaseAddAuthenticationStatementToAssertion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAuthnStatementToAssertion.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, AuthnContextClassRefPrincipal> classRefLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, Long> sessionLifetimeLookupStrategy = new SessionLifetimeLookupFunction();

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    public void setClassRefLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnContextClassRefPrincipal> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.classRefLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication context class reference strategy cannot be null");
    }

    public void setSessionLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Long> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionLifetimeLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.classRefLookupStrategy == null) {
            this.classRefLookupStrategy = new DefaultPrincipalDeterminationStrategy(AuthnContextClassRefPrincipal.class, (Principal)new AuthnContextClassRefPrincipal("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified"));
        }
        if (this.assertionLookupStrategy == null) {
            this.assertionLookupStrategy = new AssertionStrategy();
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Assertion assertion = (Assertion)this.assertionLookupStrategy.apply((Object)profileRequestContext);
        if (assertion == null) {
            this.log.error("Unable to obtain Assertion to modify");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        AuthnStatement statement = this.buildAuthnStatement(profileRequestContext, (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class));
        assertion.getAuthnStatements().add(statement);
        this.log.debug("{} Added AuthenticationStatement to Assertion {}", (Object)this.getLogPrefix(), (Object)assertion.getID());
    }

    @Nonnull
    private AuthnStatement buildAuthnStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable RequestedPrincipalContext requestedPrincipalContext) {
        Long lifetime;
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(AuthnStatement.TYPE_NAME);
        SAMLObjectBuilder authnContextBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(AuthnContext.TYPE_NAME);
        SAMLObjectBuilder localityBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(SubjectLocality.TYPE_NAME);
        AuthnStatement statement = (AuthnStatement)statementBuilder.buildObject();
        statement.setAuthnInstant(new DateTime(this.getAuthenticationResult().getAuthenticationInstant()));
        AuthnContext authnContext = (AuthnContext)authnContextBuilder.buildObject();
        statement.setAuthnContext(authnContext);
        if (requestedPrincipalContext != null && requestedPrincipalContext.getMatchingPrincipal() != null) {
            Principal matchingPrincipal = requestedPrincipalContext.getMatchingPrincipal();
            if (matchingPrincipal instanceof AuthnContextClassRefPrincipal) {
                authnContext.setAuthnContextClassRef(((AuthnContextClassRefPrincipal)matchingPrincipal).getAuthnContextClassRef());
            } else if (matchingPrincipal instanceof AuthnContextDeclRefPrincipal) {
                authnContext.setAuthnContextDeclRef(((AuthnContextDeclRefPrincipal)matchingPrincipal).getAuthnContextDeclRef());
            } else {
                authnContext.setAuthnContextClassRef(((AuthnContextClassRefPrincipal)this.classRefLookupStrategy.apply((Object)profileRequestContext)).getAuthnContextClassRef());
            }
        } else {
            authnContext.setAuthnContextClassRef(((AuthnContextClassRefPrincipal)this.classRefLookupStrategy.apply((Object)profileRequestContext)).getAuthnContextClassRef());
        }
        Set<ProxyAuthenticationPrincipal> proxyPrincipals = this.getAuthenticationResult().getSubject().getPrincipals(ProxyAuthenticationPrincipal.class);
        if (proxyPrincipals != null && !proxyPrincipals.isEmpty()) {
            if (proxyPrincipals.size() == 1) {
                SAMLObjectBuilder authorityBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(AuthenticatingAuthority.DEFAULT_ELEMENT_NAME);
                for (String authority : proxyPrincipals.iterator().next().getAuthorities()) {
                    AuthenticatingAuthority aa = (AuthenticatingAuthority)authorityBuilder.buildObject();
                    aa.setURI(authority);
                    authnContext.getAuthenticatingAuthorities().add(aa);
                }
            } else {
                this.log.warn("{} Multiple ProxyAuthenticationPrincipals, skipping AuthenticatingAuthority population", (Object)this.getLogPrefix());
            }
        }
        if (this.sessionLifetimeLookupStrategy != null && (lifetime = (Long)this.sessionLifetimeLookupStrategy.apply((Object)profileRequestContext)) != null && lifetime > 0L) {
            statement.setSessionNotOnOrAfter(new DateTime().plus(lifetime.longValue()));
        }
        statement.setSessionIndex(this.getIdGenerator().generateIdentifier());
        if (this.getHttpServletRequest() != null) {
            SubjectLocality locality = (SubjectLocality)localityBuilder.buildObject();
            locality.setAddress(this.getHttpServletRequest().getRemoteAddr());
            statement.setSubjectLocality(locality);
        } else {
            this.log.debug("{} HttpServletRequest not available, omitting SubjectLocality element", (Object)this.getLogPrefix());
        }
        return statement;
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            if (input != null && input.getOutboundMessageContext() != null) {
                Object outboundMessage = input.getOutboundMessageContext().getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML2ActionSupport.buildAssertion((AbstractProfileAction)AddAuthnStatementToAssertion.this, (IdentifierGenerationStrategy)AddAuthnStatementToAssertion.this.getIdGenerator(), (String)AddAuthnStatementToAssertion.this.getIssuerId());
                    input.getOutboundMessageContext().setMessage((Object)ret);
                    return ret;
                }
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    if (AddAuthnStatementToAssertion.this.isStatementInOwnAssertion() || ((Response)outboundMessage).getAssertions().isEmpty()) {
                        return SAML2ActionSupport.addAssertionToResponse((AbstractProfileAction)AddAuthnStatementToAssertion.this, (Response)((Response)outboundMessage), (IdentifierGenerationStrategy)AddAuthnStatementToAssertion.this.getIdGenerator(), (String)AddAuthnStatementToAssertion.this.getIssuerId());
                    }
                    return (Assertion)((Response)outboundMessage).getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

