/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Function;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.DelegatedAssertionLookupStrategy;
import net.shibboleth.idp.saml.xmlobject.DelegationPolicy;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public class AddDelegationPolicyToAssertion
extends AbstractProfileAction {
    public static final Long DEFAULT_POLICY_MAX_CHAIN_LENGTH = 1L;
    private Logger log = LoggerFactory.getLogger(AddDelegationPolicyToAssertion.class);
    @Nonnull
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Assertion> assertionTokenStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    private Assertion assertion;
    @Nullable
    private Assertion attestedAssertion;
    @Nullable
    private Long maxChainLength;

    public AddDelegationPolicyToAssertion() {
        this.assertionLookupStrategy = new AssertionStrategy();
        this.assertionTokenStrategy = new DelegatedAssertionLookupStrategy();
    }

    public void setAssertionTokenStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionTokenStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion token strategy may not be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy may not be null");
    }

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.assertion = (Assertion)this.assertionLookupStrategy.apply((Object)profileRequestContext);
        if (this.assertion == null) {
            this.log.debug("No assertion found, nothing to do");
            return false;
        }
        this.attestedAssertion = (Assertion)this.assertionTokenStrategy.apply((Object)profileRequestContext);
        this.maxChainLength = this.resolveMaxChainLength(profileRequestContext);
        this.log.debug("Resolved token max delegation chain length: {}", (Object)this.maxChainLength);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        DelegationPolicy delegationPolicy = (DelegationPolicy)XMLObjectSupport.buildXMLObject((QName)DelegationPolicy.DEFAULT_ELEMENT_NAME);
        delegationPolicy.setMaximumTokenDelegationChainLength(this.maxChainLength);
        if (this.assertion.getAdvice() == null) {
            this.assertion.setAdvice((Advice)XMLObjectSupport.buildXMLObject((QName)Advice.DEFAULT_ELEMENT_NAME));
        }
        this.assertion.getAdvice().getChildren().add(delegationPolicy);
    }

    @Nonnull
    protected Long resolveMaxChainLength(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.attestedAssertion != null) {
            List inboundPolicies;
            this.log.debug("Saw inbound assertion token, attempting to extract max delegation chain length from token's DelegationPolicy");
            if (this.attestedAssertion.getAdvice() != null && (inboundPolicies = this.attestedAssertion.getAdvice().getChildren(DelegationPolicy.DEFAULT_ELEMENT_NAME)) != null && !inboundPolicies.isEmpty()) {
                return ((DelegationPolicy)inboundPolicies.get(0)).getMaximumTokenDelegationChainLength();
            }
        } else {
            this.log.debug("Attempting to resolve max delegation chain length from RP profile config");
            RelyingPartyContext relyingPartyContext = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext);
            if (relyingPartyContext != null) {
                if (relyingPartyContext.getProfileConfig() instanceof BrowserSSOProfileConfiguration) {
                    return ((BrowserSSOProfileConfiguration)relyingPartyContext.getProfileConfig()).getMaximumTokenDelegationChainLength();
                }
                this.log.debug("Profile config was not BrowserSSOProfileConfiguration, can't evaluate: {}", (Object)(relyingPartyContext.getProfileConfig() != null ? relyingPartyContext.getProfileConfig().getClass().getName() : "null"));
            }
        }
        this.log.debug("Unable to resolve max delegation chain length from inbound token or profile config, returning default: {}", (Object)DEFAULT_POLICY_MAX_CHAIN_LENGTH);
        return DEFAULT_POLICY_MAX_CHAIN_LENGTH;
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            if (input != null && input.getOutboundMessageContext() != null) {
                Object outboundMessage = input.getOutboundMessageContext().getMessage();
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    Response response = (Response)outboundMessage;
                    if (response.getAssertions().isEmpty()) {
                        return null;
                    }
                    for (Assertion theAssertion : response.getAssertions()) {
                        if (theAssertion.getAuthnStatements().isEmpty()) continue;
                        AddDelegationPolicyToAssertion.this.log.debug("Found Assertion with AuthnStatement to decorate in outbound Response");
                        return theAssertion;
                    }
                    AddDelegationPolicyToAssertion.this.log.debug("Found no Assertion with AuthnStatement in outbound Response, returning first");
                    return (Assertion)response.getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

