/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.nameid.IPersistentIdStore;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDDecoder;
import net.shibboleth.idp.saml.nameid.PersistentIdEntry;
import net.shibboleth.idp.saml.nameid.PersistentIdStore;
import net.shibboleth.idp.saml.nameid.impl.JDBCPersistentIdStore;
import net.shibboleth.idp.saml.nameid.impl.JDBCPersistentIdStoreEx;
import net.shibboleth.idp.saml.nameid.impl.PersistentIdStoreEx;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.saml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPersistentIdDecoder
extends AbstractIdentifiableInitializableComponent
implements NameIDDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredPersistentIdDecoder.class);
    @NonnullAfterInit
    private PersistentIdStoreEx pidStore;
    @Nullable
    private DataSource dataSource;
    @Nullable
    private PersistentIdStore deprecatedStore;

    @NonnullAfterInit
    public IPersistentIdStore getPersistentIdStore() {
        return this.deprecatedStore;
    }

    public void setPersistentIdStore(@Nullable IPersistentIdStore store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (store instanceof PersistentIdStoreEx) {
            this.pidStore = (PersistentIdStoreEx)store;
            this.deprecatedStore = null;
        } else if (store instanceof PersistentIdStore) {
            this.deprecatedStore = (PersistentIdStore)store;
            this.pidStore = null;
        } else {
            this.pidStore = null;
            this.deprecatedStore = null;
        }
    }

    public void setDataSource(@Nullable DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSource = source;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.pidStore) {
            if (this.dataSource != null) {
                this.log.debug("Creating JDBCPersistentStoreEx instance around supplied DataSource");
                JDBCPersistentIdStoreEx newStore = new JDBCPersistentIdStoreEx();
                newStore.setVerifyDatabase(false);
                newStore.setDataSource(this.dataSource);
                newStore.initialize();
                this.pidStore = newStore;
            } else if (this.deprecatedStore != null) {
                if (this.deprecatedStore instanceof JDBCPersistentIdStore) {
                    this.log.warn("Transferring settings from deprecated JDBCPersistentStore, please update configuration");
                    JDBCPersistentIdStoreEx newStore = new JDBCPersistentIdStoreEx();
                    newStore.setVerifyDatabase(false);
                    newStore.setDataSource(((JDBCPersistentIdStore)this.deprecatedStore).getDataSource());
                    newStore.setQueryTimeout(((JDBCPersistentIdStore)this.deprecatedStore).getQueryTimeout());
                    newStore.setLocalEntityColumn(((JDBCPersistentIdStore)this.deprecatedStore).getLocalEntityColumn());
                    newStore.setPeerEntityColumn(((JDBCPersistentIdStore)this.deprecatedStore).getPeerEntityColumn());
                    newStore.setPersistentIdColumn(((JDBCPersistentIdStore)this.deprecatedStore).getPersistentIdColumn());
                    newStore.setPrincipalNameColumn(((JDBCPersistentIdStore)this.deprecatedStore).getPrincipalNameColumn());
                    newStore.setSourceIdColumn(((JDBCPersistentIdStore)this.deprecatedStore).getSourceIdColumn());
                    newStore.setPeerProvidedIdColumn(((JDBCPersistentIdStore)this.deprecatedStore).getPeerProvidedIdColumn());
                    newStore.setCreateTimeColumn(((JDBCPersistentIdStore)this.deprecatedStore).getCreateTimeColumn());
                    newStore.setDeactivationTimeColumn(((JDBCPersistentIdStore)this.deprecatedStore).getDeactivationTimeColumn());
                    newStore.initialize();
                    this.pidStore = newStore;
                } else {
                    throw new ComponentInitializationException("Non-JDBC version of deprecated PersistentIdStore interface is not usable in this version");
                }
            }
            if (null == this.pidStore) {
                throw new ComponentInitializationException("PersistentIdStore cannot be null");
            }
        }
    }

    @Nonnull
    @NotEmpty
    public String decode(@Nonnull SubjectCanonicalizationContext c14nContext, @Nonnull NameID nameID) throws NameDecoderException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (nameID.getValue() == null) {
            throw new NameDecoderException("Persistent NameID was empty");
        }
        String recipientID = nameID.getSPNameQualifier();
        if (recipientID == null && (recipientID = c14nContext.getRequesterId()) == null) {
            throw new NameDecoderException("SPNameQualifier and requester ID were null");
        }
        String issuerID = nameID.getNameQualifier();
        if (issuerID == null && (issuerID = c14nContext.getResponderId()) == null) {
            throw new NameDecoderException("NameQualifier and responder ID were null");
        }
        try {
            PersistentIdEntry entry = this.pidStore.getByIssuedValue(issuerID, recipientID, nameID.getValue());
            if (entry == null || entry.getPrincipalName() == null) {
                this.log.info("No entry found for persistent ID {}", (Object)nameID.getValue());
                return null;
            }
            return entry.getPrincipalName();
        }
        catch (IOException e) {
            this.log.error("I/O error looking up persistent ID", (Throwable)e);
            return null;
        }
    }
}

