/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeOutboundMessageContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOutboundMessageContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    private Function<ProfileRequestContext, String> selfIdentityLookupStrategy = new ResponderIdLookupFunction();
    @Nullable
    private SAMLPeerEntityContext peerEntityCtx;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setSelfIdentityLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.selfIdentityLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Self identity lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext);
        if (relyingPartyCtx == null) {
            this.log.debug("{} No relying party context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        BaseContext identifyingCtx = relyingPartyCtx.getRelyingPartyIdContextTree();
        if (identifyingCtx == null || !(identifyingCtx instanceof SAMLPeerEntityContext)) {
            this.log.debug("{} No SAML peer entity context found via relying party context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        this.peerEntityCtx = (SAMLPeerEntityContext)identifyingCtx;
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = new MessageContext();
        profileRequestContext.setOutboundMessageContext(msgCtx);
        SAMLSelfEntityContext selfContext = (SAMLSelfEntityContext)msgCtx.getSubcontext(SAMLSelfEntityContext.class, true);
        selfContext.setEntityId((String)this.selfIdentityLookupStrategy.apply((Object)profileRequestContext));
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)msgCtx.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setEntityId(this.peerEntityCtx.getEntityId());
        SAMLMetadataContext inboundMetadataCtx = (SAMLMetadataContext)this.peerEntityCtx.getSubcontext(SAMLMetadataContext.class);
        if (inboundMetadataCtx != null) {
            SAMLMetadataContext outboundMetadataCtx = (SAMLMetadataContext)peerContext.getSubcontext(SAMLMetadataContext.class, true);
            outboundMetadataCtx.setEntityDescriptor(inboundMetadataCtx.getEntityDescriptor());
            outboundMetadataCtx.setRoleDescriptor(inboundMetadataCtx.getRoleDescriptor());
            AttributeConsumingServiceContext acsCtx = (AttributeConsumingServiceContext)inboundMetadataCtx.getSubcontext(AttributeConsumingServiceContext.class);
            if (null != acsCtx) {
                ((AttributeConsumingServiceContext)outboundMetadataCtx.getSubcontext(AttributeConsumingServiceContext.class, true)).setAttributeConsumingService(acsCtx.getAttributeConsumingService());
            }
        }
        this.log.debug("{} Initialized outbound message context", (Object)this.getLogPrefix());
    }
}

