/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.shibboleth.idp.metrics.ReloadableServiceGaugeSet;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.saml.metadata.resolver.BatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataResolverServiceGaugeSet
extends ReloadableServiceGaugeSet<MetadataResolver>
implements MetricSet,
MetricFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataResolverServiceGaugeSet.class);

    public MetadataResolverServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        super(metricName);
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "update"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Instant> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof RefreshableMetadataResolver && ((RefreshableMetadataResolver)resolver).getLastUpdate() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)((RefreshableMetadataResolver)resolver).getLastUpdate());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "refresh"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Instant> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof RefreshableMetadataResolver && ((RefreshableMetadataResolver)resolver).getLastRefresh() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)((RefreshableMetadataResolver)resolver).getLastRefresh());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "successfulRefresh"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Instant> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof RefreshableMetadataResolver && ((RefreshableMetadataResolver)resolver).getLastSuccessfulRefresh() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)((RefreshableMetadataResolver)resolver).getLastSuccessfulRefresh());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)"net.shibboleth.idp", (String[])new String[]{metricName, "rootValidUntil"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Instant> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof BatchMetadataResolver && ((BatchMetadataResolver)resolver).getRootValidUntil() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)((BatchMetadataResolver)resolver).getRootValidUntil());
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Instant> valueGetter(BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver> consume) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        ServiceableComponent component = this.getService().getServiceableComponent();
        if (component != null) {
            try {
                if (!(component.getComponent() instanceof MetadataResolver)) {
                    this.log.warn("{} : Injected Service was not for an Metadata Resolver : ({}) ", (Object)this.getLogPrefix(), component.getComponent().getClass());
                } else {
                    for (MetadataResolver resolver : this.getMetadataResolvers((MetadataResolver)component.getComponent())) {
                        consume.accept((ImmutableMap.Builder<String, Instant>)mapBuilder, resolver);
                    }
                }
            }
            finally {
                component.unpinComponent();
            }
        }
        return mapBuilder.build();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        ServiceableComponent component = this.getService().getServiceableComponent();
        if (component != null) {
            try {
                if (component.getComponent() instanceof MetadataResolver) {
                    return;
                }
                this.log.error("{} : Injected service was not for a MetadataResolver ({}) ", (Object)this.getLogPrefix(), component.getClass());
                throw new ComponentInitializationException("Injected service was not for a MetadataResolver");
            }
            finally {
                component.unpinComponent();
            }
        }
        this.log.debug("{} : Injected service has not initialized sucessfully yet. Skipping type test", (Object)this.getLogPrefix());
    }

    private List<MetadataResolver> getAllChildren(ChainingMetadataResolver parent) {
        ArrayList<MetadataResolver> result = new ArrayList<MetadataResolver>(1 + parent.getResolvers().size());
        result.add((MetadataResolver)parent);
        for (MetadataResolver child : parent.getResolvers()) {
            if (child instanceof ChainingMetadataResolver) {
                result.addAll(this.getAllChildren((ChainingMetadataResolver)child));
                continue;
            }
            result.add(child);
        }
        return result;
    }

    @Nonnull
    @NonnullElements
    private Iterable<MetadataResolver> getMetadataResolvers(@Nonnull MetadataResolver rootResolver) {
        if (rootResolver instanceof ChainingMetadataResolver) {
            return this.getAllChildren((ChainingMetadataResolver)rootResolver);
        }
        return Collections.singletonList(rootResolver);
    }
}

