/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeOutboundMessageContextForError
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOutboundMessageContextForError.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLBindingContext> bindingContextLookupStrategy = new ChildContextLookup(SAMLBindingContext.class, true).compose((Function)new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @NonnullAfterInit
    private BindingDescriptor outboundBinding;
    @Nullable
    private SAMLPeerEntityContext peerEntityCtx;

    public void setBindingContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLBindingContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.bindingContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLBindingContext lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setOutboundBinding(@Nonnull @NotEmpty BindingDescriptor binding) {
        this.outboundBinding = (BindingDescriptor)Constraint.isNotNull((Object)binding, (String)"Outbound BindingDescriptor cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.outboundBinding == null) {
            throw new ComponentInitializationException("Outbound BindingDescriptor cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        BaseContext identifyingCtx;
        if (profileRequestContext.getOutboundMessageContext() != null) {
            this.log.debug("{} Outbound message context already exists, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        RelyingPartyContext relyingPartyCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (relyingPartyCtx != null && (identifyingCtx = relyingPartyCtx.getRelyingPartyIdContextTree()) != null && identifyingCtx instanceof SAMLPeerEntityContext) {
            this.peerEntityCtx = (SAMLPeerEntityContext)identifyingCtx;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = new MessageContext();
        profileRequestContext.setOutboundMessageContext(msgCtx);
        SAMLBindingContext bindingCtx = this.bindingContextLookupStrategy.apply(profileRequestContext);
        if (bindingCtx == null) {
            this.log.error("{} Unable to locate/create SAMLBindingContext to populate", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        if (profileRequestContext.getInboundMessageContext() != null) {
            bindingCtx.setRelayState(SAMLBindingSupport.getRelayState((MessageContext)profileRequestContext.getInboundMessageContext()));
        }
        bindingCtx.setBindingDescriptor(this.outboundBinding);
        if (this.peerEntityCtx != null) {
            SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)msgCtx.getSubcontext(SAMLPeerEntityContext.class, true);
            peerContext.setEntityId(this.peerEntityCtx.getEntityId());
            SAMLMetadataContext inboundMetadataCtx = (SAMLMetadataContext)this.peerEntityCtx.getSubcontext(SAMLMetadataContext.class);
            if (inboundMetadataCtx != null) {
                SAMLMetadataContext outboundMetadataCtx = (SAMLMetadataContext)peerContext.getSubcontext(SAMLMetadataContext.class, true);
                outboundMetadataCtx.setEntityDescriptor(inboundMetadataCtx.getEntityDescriptor());
                outboundMetadataCtx.setRoleDescriptor(inboundMetadataCtx.getRoleDescriptor());
            }
        }
        this.log.debug("{} Initialized outbound message context for error delivery", (Object)this.getLogPrefix());
    }
}

