/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterByQueriedAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterByQueriedAttributes.class);
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nonnull
    private Function<ProfileRequestContext, AttributeQuery> queryLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nullable
    private AttributeQuery query;
    @Nullable
    private AttributeContext attributeContext;

    public FilterByQueriedAttributes() {
        this.queryLookupStrategy = new MessageLookup(AttributeQuery.class).compose((Function)new InboundMessageContextLookup());
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setQueryLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeQuery> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.queryLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.query = this.queryLookupStrategy.apply(profileRequestContext);
        if (this.query == null || this.query.getAttributes().isEmpty()) {
            this.log.debug("No queried Attributes found, nothing to do ");
            return false;
        }
        this.attributeContext = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HashMultimap mapped = HashMultimap.create();
        ServiceableComponent component = null;
        try {
            component = this.transcoderRegistry.getServiceableComponent();
            if (component == null) {
                this.log.error("Attribute transcoder service unavailable");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
                return;
            }
            for (Attribute designator : this.query.getAttributes()) {
                try {
                    this.decodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, designator, (Multimap<String, IdPAttribute>)mapped);
                }
                catch (AttributeDecodingException e) {
                    this.log.error("{} Error decoding queried Attribute", (Object)this.getLogPrefix(), (Object)e);
                }
            }
        }
        finally {
            if (component != null) {
                component.unpinComponent();
            }
        }
        this.log.debug("{} Query content mapped to attribute IDs: {}", (Object)this.getLogPrefix(), (Object)mapped.keySet());
        ArrayList<IdPAttribute> keepers = new ArrayList<IdPAttribute>(this.query.getAttributes().size());
        for (IdPAttribute attribute : this.attributeContext.getIdPAttributes().values()) {
            Collection requested = mapped.get((Object)attribute.getId());
            if (!requested.isEmpty()) {
                this.log.debug("{} Attribute '{}' requested by query, checking for requested values", (Object)this.getLogPrefix(), (Object)attribute.getId());
                int count = this.filterRequestedValues(attribute, requested);
                if (count > 0) {
                    this.log.debug("{} Retaining requested attribute '{}' with {} value(s)", new Object[]{this.getLogPrefix(), attribute.getId(), count});
                    keepers.add(attribute);
                    continue;
                }
                this.log.debug("{} Removing requested attribute '{}', no values left after filtering", (Object)this.getLogPrefix(), (Object)attribute.getId());
                continue;
            }
            this.log.debug("{} Removing attribute '{}' not requested by query", (Object)this.getLogPrefix(), (Object)attribute.getId());
        }
        this.attributeContext.setIdPAttributes(keepers);
    }

    protected void decodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull Attribute input, @Nonnull @NonnullElements @Live Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            throw new AttributeDecodingException("No transcoding rule for Attribute '" + input.getName() + "'");
        }
        for (TranscodingRule rules : transcodingRules) {
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rules);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }

    private int filterRequestedValues(@Nonnull IdPAttribute attribute, @Nonnull @NonnullElements Collection<IdPAttribute> requestedAttributes) {
        boolean requestedValues = false;
        ArrayList<IdPAttributeValue> keepers = new ArrayList<IdPAttributeValue>(attribute.getValues().size());
        for (IdPAttributeValue value : attribute.getValues()) {
            for (IdPAttribute requested : requestedAttributes) {
                if (requested.getValues().isEmpty()) continue;
                requestedValues = true;
                if (!requested.getValues().contains(value)) continue;
                keepers.add(value);
                break;
            }
            if (requestedValues) continue;
            keepers.add(value);
        }
        attribute.setValues(keepers);
        return keepers.size();
    }
}

