/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationProcessingData;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessAssertionsForAuthentication
extends AbstractAuthenticationAction {
    private final Logger log = LoggerFactory.getLogger(ProcessAssertionsForAuthentication.class);
    @Nonnull
    private Function<ProfileRequestContext, Response> responseResolver = new DefaultResponseResolver().compose(new ChildContextLookup(ProfileRequestContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class)));
    @Nonnull
    private Function<ProfileRequestContext, SAMLAuthnContext> samlContextLookupStrategy = new ChildContextLookup(SAMLAuthnContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<List<Assertion>, Assertion> authnAssertionSelectionStrategy = assertions -> assertions.stream().filter(Objects::nonNull).sorted(Comparator.comparing(assertion -> assertion.getAuthnStatements().stream().filter(Objects::nonNull).map(AuthnStatement::getSessionNotOnOrAfter).filter(Objects::nonNull).sorted().findFirst().orElse(Instant.MAX))).findFirst().orElse(null);
    @Nonnull
    private Function<Assertion, AuthnStatement> authnStatementSelectionStrategy = assertion -> assertion.getAuthnStatements().stream().filter(Objects::nonNull).sorted(Comparator.comparing(AuthnStatement::getSessionNotOnOrAfter, Comparator.nullsLast(Comparator.naturalOrder()))).findFirst().orElse(null);
    private Response response;
    private SAMLAuthnContext samlAuthnContext;

    public void setAuthnAssertionSelectionStrategy(@Nonnull Function<List<Assertion>, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authnAssertionSelectionStrategy = (Function)Constraint.isNotNull(strategy, (String)"The Assertion selection strategy may not be null");
    }

    public void setAuthnStatementSelectionStrategy(@Nonnull Function<Assertion, AuthnStatement> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authnStatementSelectionStrategy = (Function)Constraint.isNotNull(strategy, (String)"The AuthnStatement selection strategy may not be null");
    }

    public void setResponseResolver(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responseResolver = (Function)Constraint.isNotNull(strategy, (String)"The Response resolver strategy may not be null");
    }

    public void setSAMLAuthnContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLAuthnContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.samlContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLAuthnContext lookup strategy may not be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.response = this.responseResolver.apply(profileRequestContext);
        if (this.response == null || this.response.getAssertions() == null || this.response.getAssertions().isEmpty()) {
            this.log.info("{} Profile context contained no candidate Assertions to process. Skipping further processing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return false;
        }
        this.samlAuthnContext = this.samlContextLookupStrategy.apply(profileRequestContext);
        if (this.samlAuthnContext == null) {
            this.log.debug("{} No SAMLAuthnContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        List nonValid = this.response.getAssertions().stream().filter(new AssertionIsValid().negate()).collect(Collectors.toList());
        this.log.debug("{} Removing {} non-valid Assertions from Response", (Object)this.getLogPrefix(), (Object)nonValid.size());
        this.response.getAssertions().removeAll(nonValid);
        Predicate<Assertion> selector = new AssertionContainsAuthenticationStatement().and(new AssertionContainsConfirmedSubject());
        List assertions = this.response.getAssertions().stream().filter(selector).collect(Collectors.toList());
        if (assertions.isEmpty()) {
            this.log.debug("{} No valid SAML Assertions meeting the criteria for authentication were found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        Assertion authnAssertion = null;
        if (assertions.size() == 1) {
            authnAssertion = (Assertion)assertions.get(0);
            this.log.debug("{} Saw single suitable SAML Assertion, selecting for authentication", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Attempting to select from {} suitable SAML Assertions for authentication", (Object)this.getLogPrefix(), (Object)assertions.size());
            authnAssertion = this.authnAssertionSelectionStrategy.apply(assertions);
        }
        if (authnAssertion == null) {
            this.log.debug("{} Could not select a single valid SAML Assertion for authentication", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        this.log.debug("{} Selected SAML Assertion for authentication: {}", (Object)this.getLogPrefix(), (Object)authnAssertion.getID());
        AuthnStatement authnStatement = null;
        if (authnAssertion.getAuthnStatements().size() == 1) {
            authnStatement = (AuthnStatement)authnAssertion.getAuthnStatements().get(0);
            this.log.debug("{} Saw single AuthnStatement, selecting for authentication", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Attempting to select from multiple AuthnStatements for authentication", (Object)this.getLogPrefix());
            authnStatement = this.authnStatementSelectionStrategy.apply(authnAssertion);
            if (authnStatement == null) {
                this.log.debug("{} Could not select a single AuthnStatement for authentication", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
                return;
            }
        }
        this.samlAuthnContext.setAuthnStatement(authnStatement);
        this.samlAuthnContext.setSubject(authnAssertion.getSubject());
    }

    private class AssertionContainsConfirmedSubject
    implements Predicate<Assertion> {
        private AssertionContainsConfirmedSubject() {
        }

        @Override
        public boolean test(@Nullable Assertion assertion) {
            if (assertion == null) {
                return false;
            }
            Optional validationData = assertion.getObjectMetadata().get(ValidationProcessingData.class).stream().findFirst();
            if (validationData.isEmpty()) {
                return false;
            }
            ValidationContext validationContext = ((ValidationProcessingData)validationData.get()).getContext();
            if (validationContext == null) {
                return false;
            }
            return validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation") != null;
        }
    }

    private class AssertionContainsAuthenticationStatement
    implements Predicate<Assertion> {
        private AssertionContainsAuthenticationStatement() {
        }

        @Override
        public boolean test(@Nullable Assertion assertion) {
            if (assertion == null) {
                return false;
            }
            return !assertion.getAuthnStatements().isEmpty();
        }
    }

    private class AssertionIsValid
    implements Predicate<Assertion> {
        private AssertionIsValid() {
        }

        @Override
        public boolean test(@Nullable Assertion assertion) {
            if (assertion == null) {
                return false;
            }
            Optional validationData = assertion.getObjectMetadata().get(ValidationProcessingData.class).stream().findFirst();
            if (validationData.isEmpty()) {
                return false;
            }
            return ((ValidationProcessingData)validationData.get()).getResult() == ValidationResult.VALID;
        }
    }

    private class DefaultResponseResolver
    implements Function<ProfileRequestContext, Response> {
        private DefaultResponseResolver() {
        }

        @Override
        public Response apply(@Nonnull ProfileRequestContext profileContext) {
            SAMLObject message = (SAMLObject)profileContext.getInboundMessageContext().getMessage();
            if (message instanceof Response) {
                return (Response)message;
            }
            return null;
        }
    }
}

