/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.saml.metadata.ScopesContainer;
import net.shibboleth.idp.saml.xmlobject.Scope;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

@NotThreadSafe
public class ScopesNodeProcessor
implements MetadataNodeProcessor {
    public void process(XMLObject metadataNode) throws FilterException {
        Extensions extensions;
        if (metadataNode instanceof EntityDescriptor) {
            extensions = ((EntityDescriptor)metadataNode).getExtensions();
        } else if (metadataNode instanceof RoleDescriptor) {
            extensions = ((RoleDescriptor)metadataNode).getExtensions();
        } else {
            return;
        }
        if (extensions == null) {
            return;
        }
        List scopes = extensions.getUnknownXMLObjects(Scope.DEFAULT_ELEMENT_NAME);
        if (scopes.isEmpty()) {
            return;
        }
        HashSet<String> nonRegexScopes = new HashSet<String>(scopes.size());
        HashSet<String> regexScopes = new HashSet<String>(scopes.size());
        for (XMLObject object : scopes) {
            Scope scope = (Scope)object;
            if (scope.getRegexp() != null && scope.getRegexp().booleanValue()) {
                regexScopes.add(scope.getValue());
                continue;
            }
            nonRegexScopes.add(scope.getValue());
        }
        ScopesContainer container = new ScopesContainer();
        container.setRegexpScopes(regexScopes);
        container.setSimpleScopes(nonRegexScopes);
        metadataNode.getObjectMetadata().put((Object)container);
    }
}

