/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.navigate.ForceAuthnProfileConfigPredicate;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.logic.IgnoreScopingProfileConfigPredicate;
import net.shibboleth.idp.saml.saml2.profile.config.navigate.ProxyCountLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.Scoping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeAuthenticationContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAuthenticationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = new ForceAuthnProfileConfigPredicate();
    @Nonnull
    private Predicate<ProfileRequestContext> ignoreScopingPredicate = new IgnoreScopingProfileConfigPredicate();
    @Nullable
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy = new ProxyCountLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy = new MessageLookup(AuthnRequest.class).compose((Function)new InboundMessageContextLookup());
    @Nullable
    private AuthnRequest authnRequest;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    public void setIgnoreScopingPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoreScopingPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Ignore Scoping predicate cannot be null");
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Proxy count lookup strategy cannot be null");
    }

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.authnRequest = this.requestLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuthenticationContext authnCtx = new AuthenticationContext();
        if (this.authnRequest != null) {
            SubjectContext subjectCtx;
            if (!this.processScoping(profileRequestContext, authnCtx)) {
                return;
            }
            authnCtx.setForceAuthn(this.authnRequest.isForceAuthn().booleanValue());
            authnCtx.setIsPassive(this.authnRequest.isPassive().booleanValue());
            if (this.authnRequest.getSubject() != null && this.authnRequest.getSubject().getNameID() != null && (subjectCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class)) != null && subjectCtx.getPrincipalName() != null) {
                authnCtx.setRequiredName(subjectCtx.getPrincipalName());
                profileRequestContext.removeSubcontext((BaseContext)subjectCtx);
            }
        }
        if (!authnCtx.isForceAuthn()) {
            authnCtx.setForceAuthn(this.forceAuthnPredicate.test(profileRequestContext));
        }
        Integer reqCount = authnCtx.getProxyCount();
        Integer configCount = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (configCount != null && configCount < 0) {
            configCount = 0;
        }
        if (reqCount != null) {
            if (configCount != null) {
                authnCtx.setProxyCount(Integer.valueOf(Integer.min(configCount, reqCount)));
                this.log.debug("{} Combined requested and configured proxy count: {}", (Object)this.getLogPrefix(), (Object)authnCtx.getProxyCount());
            }
        } else {
            authnCtx.setProxyCount(configCount);
        }
        profileRequestContext.addSubcontext((BaseContext)authnCtx, true);
        this.log.debug("{} Created authentication context: {}", (Object)this.getLogPrefix(), (Object)authnCtx);
    }

    private boolean processScoping(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Scoping scoping = this.authnRequest.getScoping();
        if (scoping == null) {
            this.log.debug("{} AuthnRequest did not contain Scoping, nothing to do", (Object)this.getLogPrefix());
            return true;
        }
        if (this.ignoreScopingPredicate.test(profileRequestContext)) {
            this.log.warn("{} Ignoring inbound Scoping element in AuthnRequest in violation of standard", (Object)this.getLogPrefix());
            return true;
        }
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpContext != null && rpContext.getProfileConfig() != null && rpContext.getProfileConfig() instanceof BrowserSSOProfileConfiguration && ((BrowserSSOProfileConfiguration)rpContext.getProfileConfig()).isFeatureDisallowed(profileRequestContext, 2)) {
            this.log.warn("{} Incoming Scoping disallowed by profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return false;
        }
        IDPList idpList = scoping.getIDPList();
        if (idpList != null && idpList.getIDPEntrys() != null) {
            Set requestedAuthorities = idpList.getIDPEntrys().stream().map(IDPEntry::getProviderID).filter(id -> id != null).collect(Collectors.toUnmodifiableSet());
            authenticationContext.getProxiableAuthorities().addAll(requestedAuthorities);
        }
        if (scoping.getProxyCount() != null) {
            authenticationContext.setProxyCount(Integer.valueOf(Integer.max(0, scoping.getProxyCount())));
        }
        return true;
    }
}

