/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactAwareProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageChannelSecurityContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.EndpointResolver;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLArtifactContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.BindingCriterion;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateBindingAndEndpointContexts
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateBindingAndEndpointContexts.class);
    @Nonnull
    private QName endpointType;
    @NonnullAfterInit
    private EndpointResolver<?> endpointResolver;
    @Nonnull
    private Function<ProfileRequestContext, List<BindingDescriptor>> bindingDescriptorsLookupStrategy = FunctionSupport.constant(Collections.emptyList());
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
    @Nonnull
    private Function<ProfileRequestContext, SAMLBindingContext> bindingContextLookupStrategy = new ChildContextLookup(SAMLBindingContext.class, true).compose((Function)new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, SAMLEndpointContext> endpointContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SAMLArtifactContext> artifactContextLookupStrategy = new ChildContextLookup(SAMLArtifactContext.class, true).compose((Function)new OutboundMessageContextLookup());
    @Nonnull
    @NonnullElements
    private List<BindingDescriptor> bindingDescriptors;
    private boolean artifactImpliesSecureChannel = true;
    @NonnullAfterInit
    private XMLObjectBuilder<?> endpointBuilder;
    @Nullable
    private SAMLArtifactConfiguration artifactConfiguration;
    @Nullable
    private Object inboundMessage;
    @Nullable
    private String relyingPartyId;
    @Nullable
    private SAMLMetadataContext mdContext;
    private boolean verified;
    private boolean skipValidationSinceSigned;

    public PopulateBindingAndEndpointContexts() {
        this.endpointContextLookupStrategy = new ChildContextLookup(SAMLEndpointContext.class, true).compose(new ChildContextLookup(SAMLPeerEntityContext.class, true).compose((Function)new OutboundMessageContextLookup()));
    }

    public void setEndpointType(@Nullable QName type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.endpointType = type;
    }

    public void setEndpointResolver(@Nonnull EndpointResolver<?> resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.endpointResolver = (EndpointResolver)Constraint.isNotNull(resolver, (String)"EndpointResolver cannot be null");
    }

    public void setBindingDescriptorsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<BindingDescriptor>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.bindingDescriptorsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Binding descriptors lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public void setBindingContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLBindingContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.bindingContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLBindingContext lookup strategy cannot be null");
    }

    public void setEndpointContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLEndpointContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.endpointContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLEndpointContext lookup strategy cannot be null");
    }

    public void setArtifactContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLArtifactContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.artifactContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLArtifactContext lookup strategy cannot be null");
    }

    public void setArtifactImpliesSecureChannel(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.artifactImpliesSecureChannel = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.endpointResolver == null) {
            throw new ComponentInitializationException("EndpointResolver cannot be null");
        }
        if (this.endpointType != null) {
            this.endpointBuilder = XMLObjectSupport.getBuilder((QName)this.endpointType);
            if (this.endpointBuilder == null) {
                throw new ComponentInitializationException("Unable to obtain builder for endpoint type " + this.endpointType);
            }
            if (!(this.endpointBuilder.buildObject(this.endpointType) instanceof Endpoint)) {
                throw new ComponentInitializationException("Builder for endpoint type " + this.endpointType + " did not result in Endpoint object");
            }
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpContext;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getInboundMessageContext() != null) {
            this.inboundMessage = profileRequestContext.getInboundMessageContext().getMessage();
        }
        if ((rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext)) != null) {
            this.relyingPartyId = rpContext.getRelyingPartyId();
            this.verified = rpContext.isVerified();
            if (rpContext.getProfileConfig() != null && rpContext.getProfileConfig() instanceof SAMLProfileConfiguration) {
                SAMLProfileConfiguration profileConfiguration = (SAMLProfileConfiguration)rpContext.getProfileConfig();
                if (profileConfiguration instanceof SAMLArtifactAwareProfileConfiguration) {
                    this.artifactConfiguration = ((SAMLArtifactAwareProfileConfiguration)profileConfiguration).getArtifactConfiguration(profileRequestContext);
                }
                if (profileConfiguration instanceof BrowserSSOProfileConfiguration) {
                    BrowserSSOProfileConfiguration ssoConfig = (BrowserSSOProfileConfiguration)profileConfiguration;
                    boolean bl = this.skipValidationSinceSigned = this.inboundMessage instanceof AuthnRequest && ssoConfig.isSkipEndpointValidationWhenSigned(profileRequestContext) && !ssoConfig.isIgnoreRequestSignatures(profileRequestContext) && SAMLBindingSupport.isMessageSigned((MessageContext)profileRequestContext.getInboundMessageContext());
                }
            }
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.debug("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.bindingDescriptors = this.bindingDescriptorsLookupStrategy.apply(profileRequestContext);
        if (this.bindingDescriptors == null) {
            this.bindingDescriptors = Collections.emptyList();
        }
        this.mdContext = this.metadataContextLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.handleSynchronousRequest(profileRequestContext)) {
            return;
        }
        if (this.endpointType == null) {
            this.log.error("Front-channel binding used, but no endpoint type set");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"EndpointResolutionFailed");
            return;
        }
        this.log.debug("{} Attempting to resolve endpoint of type {} for outbound message", (Object)this.getLogPrefix(), (Object)this.endpointType);
        ArrayList<String> bindings = new ArrayList<String>(this.bindingDescriptors.size());
        for (BindingDescriptor bindingDescriptor : this.bindingDescriptors) {
            if (!bindingDescriptor.test(profileRequestContext)) continue;
            bindings.add(bindingDescriptor.getId());
        }
        if (bindings.isEmpty()) {
            this.log.warn("{} No outbound bindings are eligible for use", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"EndpointResolutionFailed");
            return;
        }
        this.log.trace("{} Candidate outbound bindings: {}", (Object)this.getLogPrefix(), bindings);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new BindingCriterion(bindings), this.buildEndpointCriterion((String)bindings.get(0))});
        if (this.mdContext != null && this.mdContext.getRoleDescriptor() != null) {
            criteria.add((Object)new RoleDescriptorCriterion(this.mdContext.getRoleDescriptor()));
        } else {
            this.log.debug("{} No metadata available for endpoint resolution", (Object)this.getLogPrefix());
        }
        Endpoint resolvedEndpoint = null;
        try {
            resolvedEndpoint = (Endpoint)this.endpointResolver.resolveSingle((Object)criteria);
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving outbound message endpoint", (Object)this.getLogPrefix(), (Object)e);
        }
        if (resolvedEndpoint == null) {
            this.log.warn("{} Unable to resolve outbound message endpoint for relying party '{}': {}", new Object[]{this.getLogPrefix(), this.relyingPartyId, criteria.get(EndpointCriterion.class)});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"EndpointResolutionFailed");
            return;
        }
        String bindingURI = resolvedEndpoint.getBinding();
        this.log.debug("{} Resolved endpoint at location {} using binding {}", new Object[]{this.getLogPrefix(), resolvedEndpoint.getLocation(), bindingURI});
        SAMLEndpointContext endpointContext = this.endpointContextLookupStrategy.apply(profileRequestContext);
        endpointContext.setEndpoint(resolvedEndpoint);
        SAMLBindingContext bindingCtx = this.bindingContextLookupStrategy.apply(profileRequestContext);
        bindingCtx.setRelayState(SAMLBindingSupport.getRelayState((MessageContext)profileRequestContext.getInboundMessageContext()));
        Optional<BindingDescriptor> bindingDescriptor = this.bindingDescriptors.stream().filter(b -> b.getId().equals(bindingURI)).findFirst();
        if (bindingDescriptor.isPresent()) {
            bindingCtx.setBindingDescriptor(bindingDescriptor.orElseThrow());
        } else {
            bindingCtx.setBindingUri(resolvedEndpoint.getBinding());
        }
        if (bindingDescriptor.isPresent() && bindingDescriptor.get().isArtifact()) {
            if (this.artifactConfiguration != null) {
                SAMLArtifactContext artifactCtx = this.artifactContextLookupStrategy.apply(profileRequestContext);
                artifactCtx.setArtifactType(this.artifactConfiguration.getArtifactType());
                artifactCtx.setSourceArtifactResolutionServiceEndpointURL(this.artifactConfiguration.getArtifactResolutionServiceURL());
                artifactCtx.setSourceArtifactResolutionServiceEndpointIndex(this.artifactConfiguration.getArtifactResolutionServiceIndex());
            }
            if (this.artifactImpliesSecureChannel) {
                this.log.debug("{} Use of artifact binding implies the channel will be secure, overriding MessageChannelSecurityContext flags", (Object)this.getLogPrefix());
                MessageChannelSecurityContext channelCtx = (MessageChannelSecurityContext)profileRequestContext.getSubcontext(MessageChannelSecurityContext.class, true);
                channelCtx.setIntegrityActive(true);
                channelCtx.setConfidentialityActive(true);
            }
        }
    }

    private boolean handleSynchronousRequest(@Nonnull ProfileRequestContext profileRequestContext) {
        Optional<BindingDescriptor> binding;
        SAMLBindingContext bindingCtx;
        if (this.inboundMessage != null && (bindingCtx = (SAMLBindingContext)profileRequestContext.getInboundMessageContext().getSubcontext(SAMLBindingContext.class)) != null && bindingCtx.getBindingUri() != null && (binding = this.bindingDescriptors.stream().filter(b -> b.getId().equals(bindingCtx.getBindingUri())).findFirst()).isPresent() && binding.orElseThrow().isSynchronous()) {
            this.log.debug("{} Handling request via synchronous binding, preparing outbound binding context for {}", (Object)this.getLogPrefix(), (Object)binding.orElseThrow().getId());
            SAMLBindingContext outboundCtx = this.bindingContextLookupStrategy.apply(profileRequestContext);
            outboundCtx.setRelayState(SAMLBindingSupport.getRelayState((MessageContext)profileRequestContext.getInboundMessageContext()));
            outboundCtx.setBindingDescriptor(binding.orElseThrow());
            return true;
        }
        return false;
    }

    @Nonnull
    private EndpointCriterion<?> buildEndpointCriterion(@Nonnull @NotEmpty String unverifiedBinding) {
        Endpoint endpoint = (Endpoint)this.endpointBuilder.buildObject(this.endpointType);
        if (this.inboundMessage instanceof IdPInitiatedSSORequest) {
            this.log.debug("{} Populating template endpoint for resolution from IdP-initiated SSO request", (Object)this.getLogPrefix());
            endpoint.setLocation(((IdPInitiatedSSORequest)this.inboundMessage).getAssertionConsumerServiceURL());
        } else if (this.inboundMessage instanceof AuthnRequest) {
            this.log.debug("{} Populating template endpoint for resolution from SAML AuthnRequest", (Object)this.getLogPrefix());
            endpoint.setLocation(((AuthnRequest)this.inboundMessage).getAssertionConsumerServiceURL());
            endpoint.setBinding(((AuthnRequest)this.inboundMessage).getProtocolBinding());
            if (endpoint instanceof IndexedEndpoint) {
                ((IndexedEndpoint)endpoint).setIndex(((AuthnRequest)this.inboundMessage).getAssertionConsumerServiceIndex());
            }
        }
        if (!this.verified) {
            if (endpoint.getBinding() == null) {
                endpoint.setBinding(unverifiedBinding);
                this.log.debug("{} Defaulting binding in \"unverified\" request to {}", (Object)this.getLogPrefix(), (Object)unverifiedBinding);
            }
            return new EndpointCriterion(endpoint, true);
        }
        return new EndpointCriterion(endpoint, this.skipValidationSinceSigned);
    }
}

