/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.opensaml.saml.saml2.core.Response;

public abstract class AbstractProxyRestrictionAuditExtractor<T>
implements Function<ProfileRequestContext, T> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    protected AbstractProxyRestrictionAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = this.responseLookupStrategy.apply(input);
        if (response != null) {
            if (response instanceof ArtifactResponse) {
                response = ((ArtifactResponse)response).getMessage();
            }
            if (response instanceof Response) {
                for (Assertion assertion : ((Response)response).getAssertions()) {
                    ProxyRestriction condition;
                    Conditions conditions = assertion.getConditions();
                    if (conditions == null || (condition = conditions.getProxyRestriction()) == null) continue;
                    return this.doApply(condition);
                }
            }
        }
        return null;
    }

    @Nullable
    protected abstract T doApply(@Nullable ProxyRestriction var1);
}

