/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SubjectQuery;

public class NameIDFormatAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> messageLookupStrategy;

    public NameIDFormatAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.messageLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject msg = this.messageLookupStrategy.apply(input);
        if (msg != null) {
            if (msg instanceof ArtifactResponse) {
                ArtifactResponse ar = (ArtifactResponse)msg;
                msg = ar.getMessage();
            }
            if (msg instanceof org.opensaml.saml.saml2.core.Response) {
                for (org.opensaml.saml.saml2.core.Assertion assertion : ((org.opensaml.saml.saml2.core.Response)msg).getAssertions()) {
                    assert (assertion != null);
                    String format = this.apply(assertion);
                    if (format == null) continue;
                    return format;
                }
            } else if (msg instanceof LogoutRequest) {
                LogoutRequest logout = (LogoutRequest)msg;
                NameID nameID = logout.getNameID();
                if (nameID != null) {
                    return nameID.getFormat();
                }
            } else if (msg instanceof AuthnRequest) {
                NameID nameID;
                AuthnRequest ar = (AuthnRequest)msg;
                org.opensaml.saml.saml2.core.Subject subject = ar.getSubject();
                if (subject != null && (nameID = subject.getNameID()) != null) {
                    return nameID.getFormat();
                }
            } else if (msg instanceof Response) {
                Response resp = (Response)msg;
                for (Assertion assertion : resp.getAssertions()) {
                    assert (assertion != null);
                    String format = this.apply(assertion);
                    if (format == null) continue;
                    return format;
                }
            } else if (msg instanceof SubjectQuery) {
                NameID nameID;
                SubjectQuery q = (SubjectQuery)msg;
                org.opensaml.saml.saml2.core.Subject subject = q.getSubject();
                if (subject != null && (nameID = subject.getNameID()) != null) {
                    return nameID.getFormat();
                }
            } else if (msg instanceof org.opensaml.saml.saml1.core.SubjectQuery) {
                NameIdentifier nameID;
                org.opensaml.saml.saml1.core.SubjectQuery q = (org.opensaml.saml.saml1.core.SubjectQuery)msg;
                Subject subject = q.getSubject();
                if (subject != null && (nameID = subject.getNameIdentifier()) != null) {
                    return nameID.getFormat();
                }
            } else {
                if (msg instanceof org.opensaml.saml.saml2.core.Assertion) {
                    org.opensaml.saml.saml2.core.Assertion a = (org.opensaml.saml.saml2.core.Assertion)msg;
                    return this.apply(a);
                }
                if (msg instanceof Assertion) {
                    Assertion a = (Assertion)msg;
                    return this.apply(a);
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    private String apply(@Nonnull org.opensaml.saml.saml2.core.Assertion assertion) {
        NameID nameID;
        org.opensaml.saml.saml2.core.Subject subject = assertion.getSubject();
        if (subject != null && (nameID = subject.getNameID()) != null) {
            return nameID.getFormat();
        }
        return null;
    }

    @Override
    @Nullable
    private String apply(@Nonnull Assertion assertion) {
        NameIdentifier nameID;
        Subject subject;
        for (AuthenticationStatement statement : assertion.getAuthenticationStatements()) {
            subject = statement.getSubject();
            if (subject == null || (nameID = subject.getNameIdentifier()) == null) continue;
            return nameID.getFormat();
        }
        for (AuthenticationStatement statement : assertion.getAttributeStatements()) {
            subject = statement.getSubject();
            if (subject == null || (nameID = subject.getNameIdentifier()) == null) continue;
            return nameID.getFormat();
        }
        for (AuthenticationStatement statement : assertion.getAuthorizationDecisionStatements()) {
            subject = statement.getSubject();
            if (subject == null || (nameID = subject.getNameIdentifier()) == null) continue;
            return nameID.getFormat();
        }
        for (AuthenticationStatement statement : assertion.getSubjectStatements()) {
            subject = statement.getSubject();
            if (subject == null || (nameID = subject.getNameIdentifier()) == null) continue;
            return nameID.getFormat();
        }
        return null;
    }
}

