/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataExpiredException;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.slf4j.Logger;

public abstract class BaseCryptoTransientDecoder
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseCryptoTransientDecoder.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nullable
    private String logPrefix;

    @NonnullAfterInit
    public DataSealer getDataSealer() {
        return this.dataSealer;
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    @Nullable
    @NotEmpty
    protected String decode(@Nonnull String transientId, @Nonnull @NotEmpty String requesterId) throws NameDecoderException {
        String decodedId;
        this.checkComponentActive();
        try {
            decodedId = this.dataSealer.unwrap(transientId);
        }
        catch (DataExpiredException e) {
            throw new NameDecoderException(this.getLogPrefix() + " Principal identifier has expired");
        }
        catch (DataSealerException e) {
            throw new NameDecoderException(this.getLogPrefix() + " Caught exception unwrapping sealed transient identifier", (Exception)((Object)e));
        }
        if (Strings.isNullOrEmpty((String)decodedId)) {
            this.log.debug("{} Unable to recover principal from transient identifier: {}", (Object)this.getLogPrefix(), (Object)transientId);
            return null;
        }
        String[] parts = decodedId.split("!");
        if (parts.length != 2) {
            this.log.warn("{} Decoded principal information was invalid: {}", (Object)this.getLogPrefix(), (Object)decodedId);
            return null;
        }
        if (requesterId != null && !requesterId.equals(parts[0])) {
            this.log.warn("{} Transient identifier issued to {} but requested by {}", new Object[]{this.getLogPrefix(), parts[0], requesterId});
            return null;
        }
        return parts[1];
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSealer) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no data sealer set");
        }
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Crypto Transient Decoder '").append(this.getId()).append("':");
            prefix = builder.toString();
            assert (prefix != null);
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

