/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDCanonicalizationFlowDescriptor;
import net.shibboleth.idp.saml.nameid.NameIDDecoder;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;

public class NameIDCanonicalization
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final ActivationCondition embeddedPredicate = new ActivationCondition();
    @NonnullAfterInit
    private NameIDDecoder decoder;

    @NonnullAfterInit
    public NameIDDecoder getDecoder() {
        return this.decoder;
    }

    @NonnullAfterInit
    public void setDecoder(@Nonnull NameIDDecoder theDecoder) {
        this.checkSetterPreconditions();
        this.decoder = (NameIDDecoder)Constraint.isNotNull((Object)theDecoder, (String)"Name ID decoder cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (null == this.decoder) {
            throw new ComponentInitializationException(this.getLogPrefix() + " decoder not supplied");
        }
        super.doInitialize();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (!this.embeddedPredicate.apply(profileRequestContext, c14nContext, true)) {
            return false;
        }
        return super.doPreExecute(profileRequestContext, c14nContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        Subject subject = c14nContext.getSubject();
        assert (subject != null);
        Set<NameIDPrincipal> nameIDs = subject.getPrincipals(NameIDPrincipal.class);
        NameID nameID = nameIDs.iterator().next().getNameID();
        try {
            c14nContext.setPrincipalName(this.decoder.decode(c14nContext, nameID));
            if (c14nContext.getPrincipalName() == null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            }
        }
        catch (NameDecoderException e) {
            c14nContext.setException((Exception)((Object)e));
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SubjectCanonicalizationError");
        }
    }

    public static class ActivationCondition
    implements Predicate<ProfileRequestContext> {
        @Nonnull
        private Logger log = LoggerFactory.getLogger(ActivationCondition.class);

        @Override
        public boolean test(@Nullable ProfileRequestContext input) {
            SubjectCanonicalizationContext c14nContext;
            if (input != null && (c14nContext = (SubjectCanonicalizationContext)input.getSubcontext(SubjectCanonicalizationContext.class)) != null) {
                return this.apply(input, c14nContext, false);
            }
            return false;
        }

        protected boolean formatMatches(@Nonnull String format, @Nonnull SubjectCanonicalizationContext c14nContext) {
            SubjectCanonicalizationFlowDescriptor flowDescriptor = c14nContext.getAttemptedFlow();
            this.log.debug("Attempting to match format '{}'", (Object)format);
            if (null == flowDescriptor) {
                this.log.error("Supplied Context has no active FlowDescriptor");
                return false;
            }
            if (!(flowDescriptor instanceof NameIDCanonicalizationFlowDescriptor)) {
                this.log.error("Flow Descriptor named {} is not appropriate for NameID canonicalization.  Use class=\"{}\"", (Object)flowDescriptor.getId(), (Object)NameIDCanonicalizationFlowDescriptor.class.getCanonicalName());
                return false;
            }
            NameIDCanonicalizationFlowDescriptor nameIDDescriptor = (NameIDCanonicalizationFlowDescriptor)flowDescriptor;
            for (String testFormat : nameIDDescriptor.getFormats()) {
                if (!SAML2ObjectSupport.areNameIDFormatsEquivalent((String)testFormat, (String)format)) continue;
                this.log.debug("NameIDCanonicalizationFlowDescriptor {}: format matches {}", (Object)nameIDDescriptor.getId(), (Object)testFormat);
                return true;
            }
            this.log.debug("NameIDCanonicalizationFlowDescriptor {}: no format matches", (Object)nameIDDescriptor.getId());
            return false;
        }

        public boolean apply(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext, boolean duringAction) {
            Set<NameIDPrincipal> nameIDs = null;
            if (c14nContext.getSubject() != null) {
                Subject subject = c14nContext.getSubject();
                assert (subject != null);
                nameIDs = subject.getPrincipals(NameIDPrincipal.class);
            }
            if (nameIDs == null || nameIDs.isEmpty()) {
                c14nContext.setException((Exception)new SubjectCanonicalizationException("No NameIDPrincipals were found"));
                if (duringAction) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                }
                return false;
            }
            if (nameIDs.size() > 1) {
                c14nContext.setException((Exception)new SubjectCanonicalizationException("Multiple NameIDPrincipals were found"));
                if (duringAction) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                }
                return false;
            }
            String format = nameIDs.iterator().next().getNameID().getFormat();
            if (format == null) {
                format = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            }
            if (!this.formatMatches(format, c14nContext)) {
                c14nContext.setException((Exception)new SubjectCanonicalizationException("Format not supported"));
                if (duringAction) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                }
                return false;
            }
            return true;
        }
    }
}

