/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.NameIdentifierGenerationService;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;

public class ProxySAML2NameIDGenerator
implements SAML2NameIDGenerator {
    @Nonnull
    private final ReloadableService<NameIdentifierGenerationService> generatorService;

    public ProxySAML2NameIDGenerator(@Nonnull ReloadableService<NameIdentifierGenerationService> service) {
        this.generatorService = (ReloadableService)Constraint.isNotNull(service, (String)"NameIdentifierGenerationService cannot be null");
    }

    @Nullable
    public NameID generate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String format) throws SAMLException {
        NameID nameID;
        block8: {
            ServiceableComponent component = this.generatorService.getServiceableComponent();
            try {
                nameID = ((NameIdentifierGenerationService)component.getComponent()).getSAML2NameIDGenerator().generate(profileRequestContext, format);
                if (component == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (component != null) {
                        try {
                            component.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ServiceException e) {
                    throw new SAMLException("Invalid NameIdentifierGenerationService configuration", (Exception)((Object)e));
                }
            }
            component.close();
        }
        return nameID;
    }
}

