/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml1.profile.AbstractSAML1NameIdentifierGenerator;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class TransientSAML1NameIdentifierGenerator
extends AbstractSAML1NameIdentifierGenerator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TransientSAML1NameIdentifierGenerator.class);
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextLookupStrategy;
    @NonnullAfterInit
    private TransientIdGenerationStrategy transientIdGenerator;

    public TransientSAML1NameIdentifierGenerator() {
        this.setFormat("urn:mace:shibboleth:1.0:nameIdentifier");
        this.subjectContextLookupStrategy = new ChildContextLookup(SubjectContext.class);
        this.setDefaultIdPNameQualifierLookupStrategy((Function)new IssuerLookupFunction());
        this.setDefaultSPNameQualifierLookupStrategy((Function)new RelyingPartyIdLookupFunction());
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.subjectContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void setTransientIdGenerator(@Nonnull TransientIdGenerationStrategy generator) {
        this.checkSetterPreconditions();
        this.transientIdGenerator = (TransientIdGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"TransientIdGenerationStrategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transientIdGenerator == null) {
            throw new ComponentInitializationException("TransientIdGenerationStrategy cannot be null");
        }
    }

    @Nullable
    protected String getIdentifier(@Nonnull ProfileRequestContext profileRequestContext) throws SAMLException {
        String principalName;
        String relyingPartyId;
        Function lookup = this.getDefaultSPNameQualifierLookupStrategy();
        String string = relyingPartyId = lookup != null ? (String)lookup.apply(profileRequestContext) : null;
        if (relyingPartyId == null) {
            this.log.debug("No relying party identifier available, can't generate transient ID");
            return null;
        }
        SubjectContext subjectCtx = this.subjectContextLookupStrategy.apply(profileRequestContext);
        String string2 = principalName = subjectCtx == null ? null : subjectCtx.getPrincipalName();
        if (principalName == null) {
            this.log.debug("No principal name available, can't generate transient ID");
            return null;
        }
        try {
            return this.transientIdGenerator.generate(relyingPartyId, principalName);
        }
        catch (SAMLException e) {
            this.log.debug("Exception generating transient ID", (Throwable)e);
            return null;
        }
    }
}

