/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.AbstractInterceptorAwareProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAMLProfileConfiguration
extends AbstractInterceptorAwareProfileConfiguration
implements SAMLProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> signRequestsPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> signResponsesPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<MessageContext, Function<MessageContext, Exception>> messageHandlerLookupStrategy = FunctionSupport.constant(null);

    public AbstractSAMLProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isSignRequests(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signRequestsPredicate.test(profileRequestContext);
    }

    public void setSignRequests(boolean flag) {
        this.signRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignRequestsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    public boolean isSignResponses(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signResponsesPredicate.test(profileRequestContext);
    }

    public void setSignResponses(boolean flag) {
        this.signResponsesPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignResponsesPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signResponsesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    @Nullable
    public Function<MessageContext, Exception> getMessageHandler(@Nullable MessageContext messageContext) {
        return this.messageHandlerLookupStrategy.apply(messageContext);
    }

    public void setMessageDecorator(@Nullable Function<MessageContext, Exception> handler) {
        this.messageHandlerLookupStrategy = FunctionSupport.constant(handler);
    }

    public void setMessageHandlerLookupStrategy(@Nonnull Function<MessageContext, Function<MessageContext, Exception>> strategy) {
        this.messageHandlerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

