/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.MoreObjects;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafe
public class IdPInitiatedSSORequest {
    @Nonnull
    @NotEmpty
    private final String entityId;
    @Nullable
    private final String acsURL;
    @Nullable
    private final String relayState;
    @Nonnull
    private final Instant time;

    public IdPInitiatedSSORequest(@Nonnull @NotEmpty String newEntityId, @Nullable String url, @Nullable String target, @Nullable Instant newTime) {
        this.entityId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newEntityId), (String)"Service provider ID cannot be null or empty");
        this.acsURL = StringSupport.trimOrNull((String)url);
        this.relayState = StringSupport.trimOrNull((String)target);
        if (newTime != null) {
            this.time = newTime;
        } else {
            Instant now = Instant.now();
            assert (now != null);
            this.time = now;
        }
    }

    @Nonnull
    @NotEmpty
    public String getEntityId() {
        return this.entityId;
    }

    @Nullable
    public String getAssertionConsumerServiceURL() {
        return this.acsURL;
    }

    @Nullable
    public String getRelayState() {
        return this.relayState;
    }

    @Nonnull
    public Instant getTime() {
        return this.time;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this.entityId).add("acsURL", (Object)this.acsURL).add("relayState", (Object)this.relayState).add("time", (Object)this.time).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entityId.hashCode();
        String url = this.acsURL;
        result = url != null ? 31 * result + url.hashCode() : 31 * result + 0;
        String state = this.relayState;
        result = state != null ? 31 * result + state.hashCode() : 31 * result + 0;
        result = 31 * result + (int)(this.time.toEpochMilli() ^ this.time.toEpochMilli() >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdPInitiatedSSORequest)) {
            return false;
        }
        IdPInitiatedSSORequest other = (IdPInitiatedSSORequest)obj;
        return Objects.equals(this.entityId, other.entityId) && Objects.equals(this.acsURL, other.acsURL) && Objects.equals(this.relayState, other.relayState) && this.time.equals(other.time);
    }
}

