/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.saml.binding.BindingDescriptor;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ThreadSafeAfterInit
public class SpringAwareMessageEncoderFactory
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, MessageEncoder>,
ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringAwareMessageEncoderFactory.class);
    @Nullable
    private ApplicationContext applicationContext;

    public void setApplicationContext(@Nullable ApplicationContext context) {
        this.applicationContext = context;
    }

    @Override
    @Nullable
    public MessageEncoder apply(@Nullable ProfileRequestContext profileRequestContext) {
        org.opensaml.saml.common.binding.BindingDescriptor desc;
        this.checkComponentActive();
        assert (profileRequestContext != null);
        MessageContext obmc = profileRequestContext.getOutboundMessageContext();
        if (this.applicationContext == null) {
            this.log.warn("No Spring ApplicationContext set");
            return null;
        }
        if (obmc == null) {
            this.log.warn("No outbound message context, unable to lookup message encoder");
            return null;
        }
        SAMLBindingContext bindingContext = (SAMLBindingContext)obmc.getSubcontext(SAMLBindingContext.class);
        org.opensaml.saml.common.binding.BindingDescriptor bindingDescriptor = desc = bindingContext == null ? null : bindingContext.getBindingDescriptor();
        if (bindingContext == null || desc == null || !(desc instanceof BindingDescriptor)) {
            this.log.warn("BindingDescriptor was not available, unable to lookup message encoder");
            return null;
        }
        this.log.debug("Looking up message encoder based on binding URI: {}", (Object)bindingContext.getBindingUri());
        BindingDescriptor descriptor = (BindingDescriptor)desc;
        String beanId = descriptor.getEncoderBeanId();
        if (beanId != null) {
            try {
                assert (this.applicationContext != null);
                return (MessageEncoder)this.applicationContext.getBean(beanId, MessageEncoder.class);
            }
            catch (BeansException e) {
                this.log.warn("Error instantiating message encoder from bean ID {}", (Object)descriptor.getEncoderBeanId(), (Object)e);
            }
        }
        this.log.warn("Failed to find a message encoder based on binding URI: {}", (Object)bindingContext.getBindingUri());
        return null;
    }
}

