/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.impl.AbstractSAML2AssertionProducingProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoConfidentialityMessageChannelPredicate;
import org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate;

public class AttributeQueryProfileConfiguration
extends AbstractSAML2AssertionProducingProfileConfiguration
implements net.shibboleth.idp.saml.saml2.profile.config.AttributeQueryProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.sam2.query.attribute";
    @Nonnull
    private Predicate<ProfileRequestContext> randomizeFriendlyNamePredicate;

    public AttributeQueryProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml2/query/attribute");
    }

    protected AttributeQueryProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponsesPredicate((Predicate<ProfileRequestContext>)new NoIntegrityMessageChannelPredicate());
        this.setEncryptAssertionsPredicate((Predicate<ProfileRequestContext>)new NoConfidentialityMessageChannelPredicate());
        this.randomizeFriendlyNamePredicate = PredicateSupport.alwaysFalse();
    }

    public boolean isRandomizeFriendlyName(@Nullable ProfileRequestContext profileRequestContext) {
        return this.randomizeFriendlyNamePredicate.test(profileRequestContext);
    }

    public void setRandomizeFriendlyName(boolean flag) {
        this.randomizeFriendlyNamePredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setRandomizeFriendlyNamePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.randomizeFriendlyNamePredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }
}

