/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.impl.BrowserSSOProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class ECPProfileConfiguration
extends BrowserSSOProfileConfiguration
implements net.shibboleth.idp.saml.saml2.profile.config.ECPProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.saml2.sso.ecp";
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> localEventsLookupStrategy = FunctionSupport.constant(null);

    public ECPProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml2/sso/ecp");
        this.localEventsLookupStrategy = FunctionSupport.constant(null);
    }

    protected ECPProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getLocalEvents(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> events = this.localEventsLookupStrategy.apply(profileRequestContext);
        if (events != null) {
            return CollectionSupport.copyToSet(events);
        }
        return CollectionSupport.emptySet();
    }

    public void setLocalEvents(@Nullable Collection<String> events) {
        this.localEventsLookupStrategy = events != null && !events.isEmpty() ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(events))) : FunctionSupport.constant(null);
    }

    public void setLocalEventsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.localEventsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

