/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Subject;

public class SAMLAuthnContext
extends BaseContext {
    @Nullable
    private MessageHandler outboundMessageHandler;
    @Nonnull
    private ProfileAction encodeMessageAction;
    @Nonnull
    private Function<String, MessageDecoder> decoderFactory;
    @Nullable
    private Subject subject;
    @Nullable
    private AuthnStatement authnStatement;

    public SAMLAuthnContext(@Nonnull ProfileAction action, @Nonnull Function<String, MessageDecoder> factory) {
        this.encodeMessageAction = (ProfileAction)Constraint.isNotNull((Object)action, (String)"Profile action cannot be null");
        this.decoderFactory = (Function)Constraint.isNotNull(factory, (String)"MessageDecoder factory cannot be null");
    }

    @Nonnull
    public ProfileAction getEncodeMessageAction() {
        return this.encodeMessageAction;
    }

    @Nonnull
    public Function<String, MessageDecoder> getMessageDecoderFactory() {
        return this.decoderFactory;
    }

    @Nullable
    public MessageHandler getOutboundMessageHandler() {
        return this.outboundMessageHandler;
    }

    @Nonnull
    public SAMLAuthnContext setOutboundMessageHandler(@Nullable MessageHandler handler) {
        this.outboundMessageHandler = handler;
        return this;
    }

    @Nullable
    public Subject getSubject() {
        return this.subject;
    }

    @Nonnull
    public SAMLAuthnContext setSubject(@Nullable Subject sub) {
        this.subject = sub;
        return this;
    }

    @Nullable
    public AuthnStatement getAuthnStatement() {
        return this.authnStatement;
    }

    @Nonnull
    public SAMLAuthnContext setAuthnStatement(@Nullable AuthnStatement statement) {
        this.authnStatement = statement;
        return this;
    }
}

