/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.DefaultPrincipalDeterminationStrategy;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.profile.config.navigate.SessionLifetimeLookupFunction;
import net.shibboleth.idp.saml.profile.impl.BaseAddAuthenticationStatementToAssertion;
import net.shibboleth.idp.saml.saml2.profile.config.logic.SuppressAuthenticatingAuthorityPredicate;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;

public class AddAuthnStatementToAssertion
extends BaseAddAuthenticationStatementToAssertion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAuthnStatementToAssertion.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, AuthnContextClassRefPrincipal> classRefLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, Duration> sessionLifetimeLookupStrategy = new SessionLifetimeLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> suppressAuthenticatingAuthorityPredicate = new SuppressAuthenticatingAuthorityPredicate();

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        this.checkSetterPreconditions();
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    public void setClassRefLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnContextClassRefPrincipal> strategy) {
        this.checkSetterPreconditions();
        this.classRefLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication context class reference strategy cannot be null");
    }

    public void setSessionLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.sessionLifetimeLookupStrategy = strategy;
    }

    public void setSuppressAuthenticatingAuthorityPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.suppressAuthenticatingAuthorityPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.classRefLookupStrategy == null) {
            this.classRefLookupStrategy = new DefaultPrincipalDeterminationStrategy(AuthnContextClassRefPrincipal.class, (Principal)new AuthnContextClassRefPrincipal("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified"));
        }
        if (this.assertionLookupStrategy == null) {
            this.assertionLookupStrategy = new AssertionStrategy();
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Assertion assertion = this.assertionLookupStrategy.apply(profileRequestContext);
        if (assertion == null) {
            this.log.error("Unable to obtain Assertion to modify");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        AuthnStatement statement = this.buildAuthnStatement(profileRequestContext, (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class));
        assertion.getAuthnStatements().add(statement);
        this.log.debug("{} Added AuthenticationStatement to Assertion {}", (Object)this.getLogPrefix(), (Object)assertion.getID());
    }

    @Nonnull
    private AuthnStatement buildAuthnStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable RequestedPrincipalContext requestedPrincipalContext) {
        Duration lifetime;
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)bf.ensureBuilder(AuthnStatement.TYPE_NAME);
        SAMLObjectBuilder authnContextBuilder = (SAMLObjectBuilder)bf.ensureBuilder(AuthnContext.TYPE_NAME);
        SAMLObjectBuilder localityBuilder = (SAMLObjectBuilder)bf.ensureBuilder(SubjectLocality.TYPE_NAME);
        AuthnStatement statement = (AuthnStatement)statementBuilder.buildObject();
        statement.setAuthnInstant(this.getAuthenticationResult().getAuthenticationInstant());
        AuthnContext authnContext = (AuthnContext)authnContextBuilder.buildObject();
        statement.setAuthnContext(authnContext);
        if (requestedPrincipalContext != null && requestedPrincipalContext.getMatchingPrincipal() != null) {
            Principal matchingPrincipal = requestedPrincipalContext.getMatchingPrincipal();
            if (matchingPrincipal instanceof AuthnContextClassRefPrincipal) {
                authnContext.setAuthnContextClassRef(((AuthnContextClassRefPrincipal)matchingPrincipal).getAuthnContextClassRef());
            } else if (matchingPrincipal instanceof AuthnContextDeclRefPrincipal) {
                authnContext.setAuthnContextDeclRef(((AuthnContextDeclRefPrincipal)matchingPrincipal).getAuthnContextDeclRef());
            } else {
                authnContext.setAuthnContextClassRef(this.classRefLookupStrategy.apply(profileRequestContext).getAuthnContextClassRef());
            }
        } else {
            authnContext.setAuthnContextClassRef(this.classRefLookupStrategy.apply(profileRequestContext).getAuthnContextClassRef());
        }
        this.addAuthenticatingAuthorities(profileRequestContext, authnContext);
        Duration duration = lifetime = this.sessionLifetimeLookupStrategy != null ? this.sessionLifetimeLookupStrategy.apply(profileRequestContext) : null;
        if (lifetime != null && lifetime.toMillis() > 0L) {
            statement.setSessionNotOnOrAfter(Instant.now().plus(lifetime));
        }
        statement.setSessionIndex(this.getIdGenerator().generateIdentifier());
        String address = this.getAddressLookupStrategy().apply(profileRequestContext);
        if (address != null) {
            SubjectLocality locality = (SubjectLocality)localityBuilder.buildObject();
            locality.setAddress(address);
            statement.setSubjectLocality(locality);
        } else {
            this.log.debug("{} Address not available, omitting SubjectLocality element", (Object)this.getLogPrefix());
        }
        return statement;
    }

    private void addAuthenticatingAuthorities(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthnContext authnContext) {
        Set<ProxyAuthenticationPrincipal> proxyPrincipals = this.getAuthenticationResult().getSubject().getPrincipals(ProxyAuthenticationPrincipal.class);
        if (proxyPrincipals != null && !proxyPrincipals.isEmpty()) {
            if (proxyPrincipals.size() == 1) {
                ProxyAuthenticationPrincipal proxyPrincipal = proxyPrincipals.iterator().next();
                boolean suppress = this.suppressAuthenticatingAuthorityPredicate.test(profileRequestContext);
                if (!suppress) {
                    SAMLObjectBuilder authorityBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(AuthenticatingAuthority.DEFAULT_ELEMENT_NAME);
                    for (String authority : proxyPrincipal.getAuthorities()) {
                        AuthenticatingAuthority aa = (AuthenticatingAuthority)authorityBuilder.buildObject();
                        aa.setURI(authority);
                        authnContext.getAuthenticatingAuthorities().add(aa);
                    }
                } else {
                    this.log.debug("{} Suppressing AuthenticatingAuthority population", (Object)this.getLogPrefix());
                }
            } else {
                this.log.warn("{} Multiple ProxyAuthenticationPrincipals, skipping AuthenticatingAuthority population", (Object)this.getLogPrefix());
            }
        }
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Override
        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            MessageContext omc;
            MessageContext messageContext = omc = input != null ? input.getOutboundMessageContext() : null;
            if (omc != null) {
                Object outboundMessage = omc.getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML2ActionSupport.buildAssertion((AbstractProfileAction)AddAuthnStatementToAssertion.this, (IdentifierGenerationStrategy)AddAuthnStatementToAssertion.this.getIdGenerator(), (String)AddAuthnStatementToAssertion.this.getIssuerId());
                    omc.setMessage((Object)ret);
                    return ret;
                }
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    if (AddAuthnStatementToAssertion.this.isStatementInOwnAssertion() || ((Response)outboundMessage).getAssertions().isEmpty()) {
                        return SAML2ActionSupport.addAssertionToResponse((AbstractProfileAction)AddAuthnStatementToAssertion.this, (Response)((Response)outboundMessage), (IdentifierGenerationStrategy)AddAuthnStatementToAssertion.this.getIdGenerator(), (String)AddAuthnStatementToAssertion.this.getIssuerId());
                    }
                    return (Assertion)((Response)outboundMessage).getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

