/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.slf4j.Logger;

public class FilterByQueriedAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterByQueriedAttributes.class);
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nonnull
    private Function<ProfileRequestContext, AttributeQuery> queryLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @NonnullBeforeExec
    private AttributeQuery query;
    @NonnullBeforeExec
    private AttributeContext attributeContext;

    public FilterByQueriedAttributes() {
        Function acls = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (acls != null);
        this.attributeContextLookupStrategy = acls;
        Function qls = new MessageLookup(AttributeQuery.class).compose((Function)new InboundMessageContextLookup());
        assert (qls != null);
        this.queryLookupStrategy = qls;
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.checkSetterPreconditions();
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setQueryLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeQuery> strategy) {
        this.checkSetterPreconditions();
        this.queryLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.query = this.queryLookupStrategy.apply(profileRequestContext);
        if (this.query == null || this.query.getAttributes().isEmpty()) {
            this.log.debug("No queried Attributes found, nothing to do ");
            return false;
        }
        this.attributeContext = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HashMultimap mapped = HashMultimap.create();
        assert (mapped != null);
        try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
            for (Attribute designator : this.query.getAttributes()) {
                assert (designator != null);
                try {
                    this.decodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, designator, (Multimap<String, IdPAttribute>)mapped);
                }
                catch (AttributeDecodingException e) {
                    this.log.error("{} Error decoding queried Attribute", (Object)this.getLogPrefix(), (Object)e);
                }
            }
        }
        catch (ServiceException e) {
            this.log.error("Attribute transcoder service unavailable", (Throwable)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
        this.log.debug("{} Query content mapped to attribute IDs: {}", (Object)this.getLogPrefix(), (Object)mapped.keySet());
        ArrayList<IdPAttribute> keepers = new ArrayList<IdPAttribute>(this.query.getAttributes().size());
        for (IdPAttribute attribute : this.attributeContext.getIdPAttributes().values()) {
            Collection requested = mapped.get((Object)attribute.getId());
            if (!requested.isEmpty()) {
                this.log.debug("{} Attribute '{}' requested by query, checking for requested values", (Object)this.getLogPrefix(), (Object)attribute.getId());
                int count = this.filterRequestedValues(attribute, requested);
                if (count > 0) {
                    this.log.debug("{} Retaining requested attribute '{}' with {} value(s)", new Object[]{this.getLogPrefix(), attribute.getId(), count});
                    keepers.add(attribute);
                    continue;
                }
                this.log.debug("{} Removing requested attribute '{}', no values left after filtering", (Object)this.getLogPrefix(), (Object)attribute.getId());
                continue;
            }
            this.log.debug("{} Removing attribute '{}' not requested by query", (Object)this.getLogPrefix(), (Object)attribute.getId());
        }
        this.attributeContext.setIdPAttributes(keepers);
    }

    protected void decodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull Attribute input, @Nonnull @Live Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            throw new AttributeDecodingException("No transcoding rule for Attribute '" + input.getName() + "'");
        }
        for (TranscodingRule rules : transcodingRules) {
            assert (rules != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rules);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }

    private int filterRequestedValues(@Nonnull IdPAttribute attribute, @Nonnull Collection<IdPAttribute> requestedAttributes) {
        boolean requestedValues = false;
        ArrayList<IdPAttributeValue> keepers = new ArrayList<IdPAttributeValue>(attribute.getValues().size());
        for (IdPAttributeValue value : attribute.getValues()) {
            for (IdPAttribute requested : requestedAttributes) {
                if (requested.getValues().isEmpty()) continue;
                requestedValues = true;
                if (!requested.getValues().contains(value)) continue;
                keepers.add(value);
                break;
            }
            if (requestedValues) continue;
            keepers.add(value);
        }
        attribute.setValues(keepers);
        return keepers.size();
    }
}

