/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLMessageReceivedEndpointContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.slf4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"%{idp.authn.SAML.externalAuthnPath:/Authn/SAML2}"})
public class SAMLAuthnController
extends AbstractInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLAuthnController.class);
    @Nonnull
    private Function<ProfileRequestContext, ProfileRequestContext> profileRequestContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SAMLAuthnContext> samlContextLookupStrategy;
    @Nonnull
    private Map<String, BindingDescriptor> bindingMap;

    public SAMLAuthnController() {
        Function prcls = new ChildContextLookup(ProfileRequestContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
        assert (prcls != null);
        this.profileRequestContextLookupStrategy = prcls;
        Function scls = new ChildContextLookup(SAMLAuthnContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
        assert (scls != null);
        this.samlContextLookupStrategy = scls;
        this.bindingMap = CollectionSupport.emptyMap();
    }

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ProfileRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.profileRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    public void setSAMLAuthnContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLAuthnContext> strategy) {
        this.checkSetterPreconditions();
        this.samlContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLAuthnContext lookup strategy cannot be null");
    }

    public void setInboundBindings(@Nullable Collection<BindingDescriptor> bindings) {
        this.checkSetterPreconditions();
        if (bindings != null) {
            this.bindingMap = new HashMap<String, BindingDescriptor>(bindings.size());
            bindings.forEach(b -> this.bindingMap.put(b.getShortName(), (BindingDescriptor)b));
        } else {
            this.bindingMap = CollectionSupport.emptyMap();
        }
    }

    @GetMapping(value={"/{binding}/SSO/start"})
    public void startSAML(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @PathVariable @Nonnull @NotEmpty String binding) throws ExternalAuthenticationException, IOException {
        Object object;
        String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        SAMLAuthnContext samlContext = this.samlContextLookupStrategy.apply(prc);
        if (samlContext == null) {
            this.log.error("SAMLAuthnContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        ProfileRequestContext nestedPRC = this.profileRequestContextLookupStrategy.apply(prc);
        if (nestedPRC == null) {
            this.log.error("Nested ProfileRequestContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        MessageContext nestedOmc = nestedPRC.getOutboundMessageContext();
        if (nestedOmc != null && (object = nestedOmc.getMessage()) instanceof AuthnRequest) {
            AuthnRequest authnRequest = (AuthnRequest)object;
            SAMLBindingSupport.setRelayState((MessageContext)nestedOmc, (String)key);
            StringBuffer url = httpRequest.getRequestURL();
            authnRequest.setAssertionConsumerServiceURL(url.substring(0, url.lastIndexOf("/start")));
            BindingDescriptor bd = this.bindingMap.get(binding);
            if (bd != null) {
                authnRequest.setProtocolBinding(bd.ensureId());
            }
        } else {
            this.log.error("Outbound AuthnContext message not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidMessage");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        try {
            Object event;
            MessageHandler handler = samlContext.getOutboundMessageHandler();
            if (handler != null) {
                handler.invoke(nestedOmc);
            }
            samlContext.getEncodeMessageAction().execute(nestedPRC);
            EventContext eventCtx = (EventContext)nestedPRC.getSubcontext(EventContext.class);
            Object object2 = event = eventCtx != null ? eventCtx.getEvent() : null;
            if (event != null && !"proceed".equals(event)) {
                this.log.error("Message encoding action signaled non-proceed event {}", event);
                httpRequest.setAttribute("authnError", (Object)event.toString());
                ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                return;
            }
        }
        catch (MessageHandlerException e) {
            this.log.error("Caught message handling exception", (Throwable)e);
            httpRequest.setAttribute("authnError", (Object)"MessageProcessingError");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{binding}/SSO"})
    public void finishSAML(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @PathVariable @Nonnull @NotEmpty String binding) throws ExternalAuthenticationException, IOException {
        String key = httpRequest.getParameter("RelayState");
        if (key == null) {
            throw new ExternalAuthenticationException("No RelayState parameter, unable to resume flow execution");
        }
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        SAMLAuthnContext samlContext = this.samlContextLookupStrategy.apply(prc);
        if (samlContext == null) {
            this.log.error("SAMLAuthnContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        ProfileRequestContext nestedPRC = this.profileRequestContextLookupStrategy.apply(prc);
        if (nestedPRC == null) {
            this.log.error("Nested ProfileRequestContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        try {
            MessageDecoder decoder = samlContext.getMessageDecoderFactory().apply(binding);
            if (decoder == null) {
                throw new MessageDecodingException("Unable to obtain MessageDecoder for binding key: " + binding);
            }
            try {
                decoder.initialize();
                decoder.decode();
                MessageContext messageContext = decoder.getMessageContext();
                assert (messageContext != null);
                messageContext.addSubcontext((BaseContext)new SAMLMessageReceivedEndpointContext(httpRequest));
                nestedPRC.setInboundMessageContext(messageContext);
            }
            finally {
                decoder.destroy();
            }
        }
        catch (ComponentInitializationException | MessageDecodingException e) {
            this.log.error("Unable to decode SAML response", e);
            httpRequest.setAttribute("authnError", (Object)"UnableToDecode");
        }
        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }
}

