/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextDeclRef;
import org.slf4j.Logger;

public class MapDrivenAuthnContextTranslationStrategy
implements Function<AuthnContext, Collection<Principal>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MapDrivenAuthnContextTranslationStrategy.class);
    @Nonnull
    private Map<Principal, Collection<Principal>> principalMappings = CollectionSupport.emptyMap();

    public void setMappings(@Nullable Map<Principal, Collection<Principal>> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            this.principalMappings = CollectionSupport.emptyMap();
            return;
        }
        this.principalMappings = new HashMap<Principal, Collection<Principal>>(mappings.size());
        mappings.forEach((k, v) -> this.principalMappings.put((Principal)k, List.copyOf(v)));
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<Principal> apply(@Nullable AuthnContext input) {
        if (input != null) {
            AuthnContextClassRefPrincipal principal;
            String declRefURI;
            AuthnContextClassRef classRef = input.getAuthnContextClassRef();
            String classRefURI = classRef == null ? null : classRef.getURI();
            AuthnContextDeclRef declRef = input.getAuthnContextDeclRef();
            String string = declRefURI = declRef == null ? null : declRef.getURI();
            if (classRefURI != null) {
                principal = new AuthnContextClassRefPrincipal(classRefURI);
            } else if (declRefURI != null) {
                principal = new AuthnContextDeclRefPrincipal(declRefURI);
            } else {
                this.log.trace("Input AuthnContext did not contain a class or decl reference, returning nothing");
                return null;
            }
            if (this.principalMappings.containsKey(principal)) {
                Collection<Principal> mapped = this.principalMappings.get(principal);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Mapped '{}' to ", (Object)principal.getName(), mapped.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
                }
                return mapped;
            }
            this.log.trace("Passing unmapped value '{}' through", (Object)principal.getName());
            return CollectionSupport.singletonList((Object)principal);
        }
        this.log.trace("Input AuthnContext was null, returning nothing");
        return null;
    }
}

