/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal.impl;

import com.google.common.base.Strings;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.NameID;
import org.slf4j.Logger;

@ThreadSafe
public class NameIDPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_NAME_FIELD = "NID";
    @Nonnull
    @NotEmpty
    private static final String FORMAT_FIELD = "F";
    @Nonnull
    @NotEmpty
    private static final String NAME_QUALIFIER_FIELD = "NQ";
    @Nonnull
    @NotEmpty
    private static final String SP_NAME_QUALIFIER_FIELD = "SPNQ";
    @Nonnull
    @NotEmpty
    private static final String SP_PROVIDED_ID_FIELD = "SPID";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"NID\":.*}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NameIDPrincipalSerializer.class);
    @Nonnull
    private final SAMLObjectBuilder<NameID> nameIDBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(NameID.DEFAULT_ELEMENT_NAME);

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof NameIDPrincipal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        NameID nameID = ((NameIDPrincipal)principal).getNameID();
        StringWriter sink = new StringWriter(128);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject().write(PRINCIPAL_NAME_FIELD, nameID.getValue());
            if (nameID.getFormat() != null) {
                gen.write(FORMAT_FIELD, nameID.getFormat());
            }
            if (nameID.getNameQualifier() != null) {
                gen.write(NAME_QUALIFIER_FIELD, nameID.getNameQualifier());
            }
            if (nameID.getSPNameQualifier() != null) {
                gen.write(SP_NAME_QUALIFIER_FIELD, nameID.getSPNameQualifier());
            }
            if (nameID.getSPProvidedID() != null) {
                gen.write(SP_PROVIDED_ID_FIELD, nameID.getSPProvidedID());
            }
            gen.writeEnd();
        }
        String result = sink.toString();
        assert (result != null);
        return result;
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public NameIDPrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing NameIDPrincipal");
            }
            JsonObject obj = (JsonObject)st;
            JsonString str = obj.getJsonString(PRINCIPAL_NAME_FIELD);
            if (str != null && !Strings.isNullOrEmpty((String)str.getString())) {
                NameID nameID = (NameID)this.nameIDBuilder.buildObject();
                nameID.setValue(str.getString());
                str = obj.getJsonString(FORMAT_FIELD);
                if (str != null && !Strings.isNullOrEmpty((String)str.getString())) {
                    nameID.setFormat(str.getString());
                }
                if ((str = obj.getJsonString(NAME_QUALIFIER_FIELD)) != null && !Strings.isNullOrEmpty((String)str.getString())) {
                    nameID.setNameQualifier(str.getString());
                }
                if ((str = obj.getJsonString(SP_NAME_QUALIFIER_FIELD)) != null && !Strings.isNullOrEmpty((String)str.getString())) {
                    nameID.setSPNameQualifier(str.getString());
                }
                if ((str = obj.getJsonString(SP_PROVIDED_ID_FIELD)) != null && !Strings.isNullOrEmpty((String)str.getString())) {
                    nameID.setSPProvidedID(str.getString());
                }
                NameIDPrincipal nameIDPrincipal2 = new NameIDPrincipal(nameID);
                return nameIDPrincipal2;
            }
            this.log.warn("Skipping NameIDPrincipal missing identifier value");
            NameIDPrincipal nameIDPrincipal = null;
            return nameIDPrincipal;
        }
        catch (JsonException e) {
            throw new IOException("Found invalid data structure while parsing NameIDPrincipal", e);
        }
    }
}

