/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.NameIdentifierGenerationService;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.profile.SAML1NameIdentifierGenerator;

public class ProxySAML1NameIdentifierGenerator
implements SAML1NameIdentifierGenerator {
    @Nonnull
    private final ReloadableService<NameIdentifierGenerationService> generatorService;

    public ProxySAML1NameIdentifierGenerator(@Nonnull ReloadableService<NameIdentifierGenerationService> service) {
        this.generatorService = (ReloadableService)Constraint.isNotNull(service, (String)"NameIdentifierGenerationService cannot be null");
    }

    @Nullable
    public NameIdentifier generate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String format) throws SAMLException {
        NameIdentifier nameIdentifier;
        block8: {
            ServiceableComponent component = this.generatorService.getServiceableComponent();
            try {
                nameIdentifier = ((NameIdentifierGenerationService)component.getComponent()).getSAML1NameIdentifierGenerator().generate(profileRequestContext, format);
                if (component == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (component != null) {
                        try {
                            component.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ServiceException e) {
                    throw new SAMLException("Invalid NameIdentifierGenerationService configuration", (Exception)((Object)e));
                }
            }
            component.close();
        }
        return nameIdentifier;
    }
}

