/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class BaseAddAuthenticationStatementToAssertion
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseAddAuthenticationStatementToAssertion.class);
    private boolean statementInOwnAssertion = false;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new IssuerLookupFunction();
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> addressLookupStrategy;
    @NonnullBeforeExec
    private AuthenticationResult authenticationResult;
    @NonnullBeforeExec
    private IdentifierGenerationStrategy idGenerator;
    @NonnullBeforeExec
    private String issuerId;

    public boolean isStatementInOwnAssertion() {
        return this.statementInOwnAssertion;
    }

    public void setStatementInOwnAssertion(boolean inOwnAssertion) {
        this.checkSetterPreconditions();
        this.statementInOwnAssertion = inOwnAssertion;
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.checkSetterPreconditions();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @NonnullAfterInit
    public Function<ProfileRequestContext, String> getAddressLookupStrategy() {
        return this.addressLookupStrategy;
    }

    public void setAddressLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.addressLookupStrategy = strategy;
    }

    @Nonnull
    public AuthenticationResult getAuthenticationResult() {
        assert (this.isPreExecuteCalled() && this.authenticationResult != null);
        return this.authenticationResult;
    }

    @Nonnull
    public IdentifierGenerationStrategy getIdGenerator() {
        assert (this.isPreExecuteCalled() && this.idGenerator != null);
        return this.idGenerator;
    }

    @Nonnull
    public String getIssuerId() {
        assert (this.isPreExecuteCalled() && this.issuerId != null);
        return this.issuerId;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.addressLookupStrategy == null) {
            this.addressLookupStrategy = new RemoteAddressStrategy();
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.log.debug("{} Attempting to add an AuthenticationStatement to outgoing Assertion", (Object)this.getLogPrefix());
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No assertion issuer value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.authenticationResult = authenticationContext.getAuthenticationResult();
        if (this.authenticationResult == null) {
            this.log.debug("{} No AuthenticationResult in current authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    private class RemoteAddressStrategy
    implements Function<ProfileRequestContext, String> {
        private RemoteAddressStrategy() {
        }

        @Override
        @Nullable
        public String apply(@Nullable ProfileRequestContext t) {
            HttpServletRequest req = BaseAddAuthenticationStatementToAssertion.this.getHttpServletRequest();
            if (req != null) {
                return HttpServletSupport.getRemoteAddr((ServletRequest)req);
            }
            return null;
        }
    }
}

