/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLSubjectNameIdentifierContext;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml2.core.NameID;
import org.slf4j.Logger;

public class ExtractSubjectFromRequest
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String NO_SUBJECT = "NoSubject";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractSubjectFromRequest.class);
    @Nullable
    private Predicate<ProfileRequestContext> nameIDPolicyPredicate;
    @Nullable
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> responderLookupStrategy = new IssuerLookupFunction();
    @NonnullBeforeExec
    private SAMLObject nameIdentifier;

    public void setRequesterLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.requesterLookupStrategy = strategy;
    }

    public void setResponderLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.responderLookupStrategy = strategy;
    }

    public void setNameIDPolicyPredicate(@Nullable Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.nameIDPolicyPredicate = predicate;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = profileRequestContext.getInboundMessageContext();
        if (msgCtx == null || msgCtx.getMessage() == null) {
            this.log.debug("{} No inbound message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)NO_SUBJECT);
            return false;
        }
        this.nameIdentifier = ((SAMLSubjectNameIdentifierContext)msgCtx.ensureSubcontext(SAMLSubjectNameIdentifierContext.class)).getSubjectNameIdentifier();
        if (this.nameIdentifier == null) {
            this.log.debug("{} No Subject NameID/NameIdentifier in message needs inbound processing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)NO_SUBJECT);
            return false;
        }
        if (this.nameIDPolicyPredicate != null && !this.nameIDPolicyPredicate.test(profileRequestContext)) {
            this.log.warn("{} Consumption of NameID/NameIdentifier blocked by policy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Subject subject;
        SAMLObject identifier = this.nameIdentifier;
        if (identifier instanceof NameIdentifier) {
            this.log.debug("{} Creating Subject for canonicalization around NameIdentifier {}", (Object)this.getLogPrefix(), (Object)((NameIdentifier)identifier).getValue());
            subject = new Subject(false, CollectionSupport.singleton((Object)new NameIdentifierPrincipal((NameIdentifier)identifier)), CollectionSupport.emptySet(), CollectionSupport.emptySet());
        } else if (identifier instanceof NameID) {
            this.log.debug("{} Creating Subject for canonicalization around NameID {}", (Object)this.getLogPrefix(), (Object)((NameID)identifier).getValue());
            subject = new Subject(false, CollectionSupport.singleton((Object)new NameIDPrincipal((NameID)identifier)), CollectionSupport.emptySet(), CollectionSupport.emptySet());
        } else {
            subject = null;
        }
        if (subject == null) {
            this.log.debug("{} Identifier was not of a supported type, ignoring", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)NO_SUBJECT);
            return;
        }
        SubjectCanonicalizationContext c14n = new SubjectCanonicalizationContext();
        c14n.setSubject(subject);
        if (this.requesterLookupStrategy != null) {
            c14n.setRequesterId(this.requesterLookupStrategy.apply(profileRequestContext));
        }
        if (this.responderLookupStrategy != null) {
            c14n.setResponderId(this.responderLookupStrategy.apply(profileRequestContext));
        }
        profileRequestContext.addSubcontext((BaseContext)c14n, true);
        this.log.debug("{} Created subject canonicalization context", (Object)this.getLogPrefix());
    }

    public static class SubjectNameLookupFunction
    implements Function<ProfileRequestContext, SAMLObject> {
        @Override
        @Nullable
        public SAMLObject apply(@Nullable ProfileRequestContext profileRequestContext) {
            MessageContext msgCtx;
            if (profileRequestContext != null && (msgCtx = profileRequestContext.getInboundMessageContext()) != null) {
                return ((SAMLSubjectNameIdentifierContext)msgCtx.ensureSubcontext(SAMLSubjectNameIdentifierContext.class)).getSubjectNameIdentifier();
            }
            return null;
        }
    }
}

