/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.slf4j.Logger;

public class PopulateInboundMessageContextWithSAMLSelf
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateInboundMessageContextWithSAMLSelf.class);
    @Nonnull
    private Function<ProfileRequestContext, String> selfIdentityLookupStrategy = new IssuerLookupFunction();

    public void setSelfIdentityLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.selfIdentityLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Self identity lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SAMLSelfEntityContext selfContext = (SAMLSelfEntityContext)profileRequestContext.ensureInboundMessageContext().ensureSubcontext(SAMLSelfEntityContext.class);
        selfContext.setEntityId(this.selfIdentityLookupStrategy.apply(profileRequestContext));
        this.log.debug("{} Populated inbound message context with SAML self entityID: {}", (Object)this.getLogPrefix(), (Object)selfContext.getEntityId());
        if (selfContext.getEntityId() == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
        }
    }
}

