/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.config.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.saml.saml1.profile.config.impl.AbstractSAML1AssertionProducingProfileConfiguration;
import net.shibboleth.profile.config.AttributeResolvingProfileConfiguration;
import net.shibboleth.saml.profile.config.SAMLAssertionProducingProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class BrowserSSOProfileConfiguration
extends AbstractSAML1AssertionProducingProfileConfiguration
implements net.shibboleth.saml.saml1.profile.config.BrowserSSOProfileConfiguration,
net.shibboleth.idp.saml.profile.config.BrowserSSOProfileConfiguration,
AuthenticationProfileConfiguration,
AttributeResolvingProfileConfiguration,
SAMLAssertionProducingProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.saml1.sso.browser";
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> includeAttributeStatementPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<Principal>> defaultAuthenticationMethodsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> nameIDFormatPrecedenceLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy;

    public BrowserSSOProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml1/sso/browser");
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponses(true);
        this.resolveAttributesPredicate = PredicateSupport.alwaysTrue();
        this.includeAttributeStatementPredicate = PredicateSupport.alwaysFalse();
        this.authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.defaultAuthenticationMethodsLookupStrategy = FunctionSupport.constant(null);
        this.nameIDFormatPrecedenceLookupStrategy = FunctionSupport.constant(null);
        this.forceAuthnPredicate = PredicateSupport.alwaysFalse();
        this.proxyCountLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isIncludeAttributeStatement(@Nullable ProfileRequestContext profileRequestContext) {
        return this.includeAttributeStatementPredicate.test(profileRequestContext);
    }

    public void setIncludeAttributeStatement(boolean flag) {
        this.includeAttributeStatementPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setIncludeAttributeStatementPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeAttributeStatementPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Include attribute statement predicate cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<Principal> methods = this.defaultAuthenticationMethodsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return CollectionSupport.copyToList(methods);
        }
        return CollectionSupport.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable Collection<Principal> methods) {
        this.defaultAuthenticationMethodsLookupStrategy = methods != null ? FunctionSupport.constant((Object)CollectionSupport.copyToList(methods)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<Principal>> strategy) {
        this.defaultAuthenticationMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToSet(flows);
        }
        return CollectionSupport.emptySet();
    }

    public void setAuthenticationFlows(@Nullable Collection<String> flows) {
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToList(flows);
        }
        return CollectionSupport.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> formats = this.nameIDFormatPrecedenceLookupStrategy.apply(profileRequestContext);
        if (formats != null) {
            return CollectionSupport.copyToList(formats);
        }
        return CollectionSupport.emptyList();
    }

    public void setNameIDFormatPrecedence(@Nonnull Collection<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedenceLookupStrategy = FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(formats)));
    }

    public void setNameIDFormatPrecedenceLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.nameIDFormatPrecedenceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

