/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.impl.AbstractSAML2ProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoConfidentialityMessageChannelPredicate;
import org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate;

public class ArtifactResolutionProfileConfiguration
extends AbstractSAML2ProfileConfiguration
implements net.shibboleth.saml.saml2.profile.config.ArtifactResolutionProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.saml2.query.artifact";
    @Nonnull
    private Predicate<ProfileRequestContext> signAssertionsPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAssertionsPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAttributesPredicate;

    public ArtifactResolutionProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml2/query/artifact");
    }

    protected ArtifactResolutionProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponsesPredicate((Predicate<ProfileRequestContext>)new NoIntegrityMessageChannelPredicate());
        this.signAssertionsPredicate = PredicateSupport.alwaysFalse();
        this.encryptAssertionsPredicate = new NoConfidentialityMessageChannelPredicate();
        this.encryptAttributesPredicate = PredicateSupport.alwaysFalse();
    }

    public boolean isSignAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signAssertionsPredicate.test(profileRequestContext);
    }

    public void setSignAssertions(boolean flag) {
        this.signAssertionsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    public boolean isEncryptAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptAssertionsPredicate.test(profileRequestContext);
    }

    public void setEncryptAssertions(boolean flag) {
        this.encryptAssertionsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setEncryptAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    public boolean isEncryptAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptAttributesPredicate.test(profileRequestContext);
    }

    public void setEncryptAttributes(boolean flag) {
        this.encryptAttributesPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setEncryptAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAttributesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }
}

