/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.messaging.context.navigate.RootContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.ext.reqattr.RequestedAttributes;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;

public class AddAuthnRequest
extends AbstractAuthenticationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAuthnRequest.class);
    private boolean overwriteExisting;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> requesterLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ProxiedRequesterContext> proxiedRequesterContextLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, NameID> nameIDLookupStrategy;
    private boolean convertUnknownRequestedPrincipals;
    @NonnullBeforeExec
    private IdentifierGenerationStrategy idGenerator;
    @NonnullBeforeExec
    private BrowserSSOProfileConfiguration profileConfiguration;
    @Nullable
    private String issuerId;

    public AddAuthnRequest() {
        this.setAuthenticationContextLookupStrategy((Function)new ParentContextLookup(AuthenticationContext.class));
        Function rls = new RelyingPartyIdLookupFunction().compose((Function)new RootContextLookup(ProfileRequestContext.class));
        assert (rls != null);
        this.requesterLookupStrategy = rls;
        Function prcls = new ChildContextLookup(ProxiedRequesterContext.class).compose(new InboundMessageContextLookup().compose((Function)new RootContextLookup(ProfileRequestContext.class)));
        assert (prcls != null);
        this.proxiedRequesterContextLookupStrategy = prcls;
    }

    public void setConvertUnknownRequestedPrincipals(boolean flag) {
        this.checkSetterPreconditions();
        this.convertUnknownRequestedPrincipals = flag;
    }

    public void setOverwriteExisting(boolean flag) {
        this.checkSetterPreconditions();
        this.overwriteExisting = flag;
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.checkSetterPreconditions();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = strategy;
    }

    public void setRequesterLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.requesterLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requester lookup strategy cannot be null");
    }

    public void setProxiedRequesterContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ProxiedRequesterContext> strategy) {
        this.checkSetterPreconditions();
        this.proxiedRequesterContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProxiedRequesterContext lookup strategy cannot be null");
    }

    public void setNameIDLookupStrategy(@Nullable Function<ProfileRequestContext, NameID> strategy) {
        this.checkSetterPreconditions();
        this.nameIDLookupStrategy = strategy;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        if (rpCtx != null && rpCtx.getConfiguration() != null && rpCtx.getProfileConfig() instanceof BrowserSSOProfileConfiguration) {
            this.profileConfiguration = (BrowserSSOProfileConfiguration)rpCtx.getProfileConfig();
        }
        if (this.profileConfiguration == null) {
            this.log.error("{} BrowserSSOProfileConfiguration not found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageCtx == null) {
            this.log.debug("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!this.overwriteExisting && outboundMessageCtx.getMessage() != null) {
            this.log.debug("{} Outbound message context already contains a message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.issuerLookupStrategy != null) {
            this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        }
        outboundMessageCtx.setMessage(null);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        List formats;
        this.log.debug("{} Building AuthnRequest for upstream IdP ({})", (Object)this.getLogPrefix(), (Object)authenticationContext.getAuthenticatingAuthority());
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)bf.ensureBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder nipBuilder = (SAMLObjectBuilder)bf.ensureBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        AuthnRequest object = (AuthnRequest)requestBuilder.buildObject();
        object.setID(this.idGenerator.generateIdentifier());
        object.setIssueInstant(Instant.now());
        object.setVersion(SAMLVersion.VERSION_20);
        Integer index = this.profileConfiguration.getAttributeIndex(profileRequestContext);
        if (index != null) {
            this.log.debug("{} Setting AttributeConsumingServiceIndex to '{}' for SAML AuthnRequest", (Object)this.getLogPrefix(), (Object)index);
            object.setAttributeConsumingServiceIndex(index);
        }
        if (this.issuerId != null) {
            this.log.debug("{} Setting Issuer to {}", (Object)this.getLogPrefix(), (Object)this.issuerId);
            SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)bf.ensureBuilder(Issuer.DEFAULT_ELEMENT_NAME);
            Issuer issuer = (Issuer)issuerBuilder.buildObject();
            issuer.setValue(this.issuerId);
            object.setIssuer(issuer);
        } else {
            this.log.debug("{} No issuer value available, leaving Issuer unset", (Object)this.getLogPrefix());
        }
        if (this.profileConfiguration.isForceAuthn(profileRequestContext)) {
            this.log.debug("{} Setting ForceAuthn for SAML AuthnRequest", (Object)this.getLogPrefix());
            object.setForceAuthn(Boolean.valueOf(true));
        }
        if (authenticationContext.isPassive()) {
            this.log.debug("{} Setting IsPassive for SAML AuthnRequest", (Object)this.getLogPrefix());
            object.setIsPassive(Boolean.valueOf(true));
        }
        NameIDPolicy nip = (NameIDPolicy)nipBuilder.buildObject();
        nip.setAllowCreate(Boolean.valueOf(true));
        String qualifier = this.profileConfiguration.getSPNameQualifier(profileRequestContext);
        if (qualifier != null) {
            this.log.debug("{} Setting NameIDPolicy SPNameQualifier to '{}' for SAML AuthnRequest", (Object)this.getLogPrefix(), (Object)qualifier);
            nip.setSPNameQualifier(qualifier);
        }
        if (!(formats = this.profileConfiguration.getNameIDFormatPrecedence(profileRequestContext)).isEmpty()) {
            this.log.debug("{} Setting NameIDPolicy Format to '{}' for SAML AuthnRequest", (Object)this.getLogPrefix(), formats.get(0));
            nip.setFormat((String)formats.get(0));
        }
        object.setNameIDPolicy(nip);
        RequestedAuthnContext rac = this.buildRequestedAuthnContext(profileRequestContext);
        if (rac != null) {
            AuthnContextComparisonTypeEnumeration operator = this.profileConfiguration.getAuthnContextComparison(profileRequestContext);
            if (operator != null) {
                this.log.debug("{} Setting RequestedAuthnContext comparison to {}", (Object)this.getLogPrefix(), (Object)operator);
                rac.setComparison(operator);
            }
            object.setRequestedAuthnContext(rac);
        }
        object.setSubject(this.buildSubject(profileRequestContext));
        object.setScoping(this.buildScoping(profileRequestContext, authenticationContext.getProxyCount(), authenticationContext.getProxiableAuthorities()));
        object.setExtensions(this.buildExtensions(profileRequestContext));
        MessageContext omc = profileRequestContext.getOutboundMessageContext();
        assert (omc != null);
        omc.setMessage((Object)object);
    }

    @Nullable
    private RequestedAuthnContext buildRequestedAuthnContext(@Nullable ProfileRequestContext profileRequestContext) {
        assert (this.profileConfiguration != null);
        List principals = this.profileConfiguration.getDefaultAuthenticationMethods(profileRequestContext);
        if (principals.isEmpty()) {
            return null;
        }
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)bf.ensureBuilder(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        List classRefPrincipals = principals.stream().filter(AuthnContextClassRefPrincipal.class::isInstance).map(AuthnContextClassRefPrincipal.class::cast).collect(Collectors.toUnmodifiableList());
        if (!classRefPrincipals.isEmpty()) {
            RequestedAuthnContext rac = (RequestedAuthnContext)builder.buildObject();
            rac.getAuthnContextClassRefs().addAll(classRefPrincipals.stream().map(AuthnContextClassRefPrincipal::getAuthnContextClassRef).collect(Collectors.toUnmodifiableList()));
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Setting RequestedAuthnContext class refs to {}", (Object)this.getLogPrefix(), classRefPrincipals.stream().map(AuthnContextClassRefPrincipal::getName).collect(Collectors.toUnmodifiableList()));
            }
            return rac;
        }
        List declRefPrincipals = principals.stream().filter(AuthnContextDeclRefPrincipal.class::isInstance).map(AuthnContextDeclRefPrincipal.class::cast).collect(Collectors.toUnmodifiableList());
        if (!declRefPrincipals.isEmpty()) {
            RequestedAuthnContext rac = (RequestedAuthnContext)builder.buildObject();
            rac.getAuthnContextDeclRefs().addAll(declRefPrincipals.stream().map(AuthnContextDeclRefPrincipal::getAuthnContextDeclRef).collect(Collectors.toUnmodifiableList()));
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Setting RequestedAuthnContext decl refs to {}", (Object)this.getLogPrefix(), declRefPrincipals.stream().map(AuthnContextDeclRefPrincipal::getName).collect(Collectors.toUnmodifiableList()));
            }
            return rac;
        }
        if (this.convertUnknownRequestedPrincipals) {
            SAMLObjectBuilder classBuilder = (SAMLObjectBuilder)bf.ensureBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
            List unknownPrincipals = principals.stream().map(p -> {
                AuthnContextClassRef ref = (AuthnContextClassRef)classBuilder.buildObject();
                ref.setURI(p.getName());
                return ref;
            }).collect(Collectors.toUnmodifiableList());
            RequestedAuthnContext rac = (RequestedAuthnContext)builder.buildObject();
            rac.getAuthnContextClassRefs().addAll(unknownPrincipals);
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Setting RequestedAuthnContext class refs to {}", (Object)this.getLogPrefix(), principals.stream().map(Principal::getName).collect(Collectors.toUnmodifiableList()));
            }
            return rac;
        }
        return null;
    }

    @Nullable
    private Subject buildSubject(@Nonnull ProfileRequestContext profileRequestContext) {
        NameID nameID;
        NameID nameID2 = nameID = this.nameIDLookupStrategy != null ? this.nameIDLookupStrategy.apply(profileRequestContext) : null;
        if (nameID == null) {
            return null;
        }
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)bf.ensureBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        subject.setNameID(nameID);
        this.log.debug("{} Populating request with NameID '{}' and Format '{}'", new Object[]{this.getLogPrefix(), nameID.getValue(), nameID.getFormat()});
        return subject;
    }

    @Nullable
    private Scoping buildScoping(@Nonnull ProfileRequestContext profileRequestContext, @Nullable Integer count, @Nonnull Set<String> idplist) {
        String immediateRequester;
        boolean include = false;
        assert (this.profileConfiguration != null);
        if (this.profileConfiguration.isIgnoreScoping(profileRequestContext)) {
            this.log.warn("{} Skipping generation of Scoping element in violation of standard", (Object)this.getLogPrefix());
            return null;
        }
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder scopingBuilder = (SAMLObjectBuilder)bf.ensureBuilder(Scoping.DEFAULT_ELEMENT_NAME);
        Scoping scoping = (Scoping)scopingBuilder.buildObject();
        if (count != null) {
            scoping.setProxyCount(Integer.valueOf(Integer.max(0, count - 1)));
            include = true;
        }
        if (!idplist.isEmpty()) {
            SAMLObjectBuilder idpListBuilder = (SAMLObjectBuilder)bf.ensureBuilder(IDPList.DEFAULT_ELEMENT_NAME);
            SAMLObjectBuilder idpBuilder = (SAMLObjectBuilder)bf.ensureBuilder(IDPEntry.DEFAULT_ELEMENT_NAME);
            IDPList idps = (IDPList)idpListBuilder.buildObject();
            for (String idp : idplist) {
                IDPEntry entry = (IDPEntry)idpBuilder.buildObject();
                entry.setProviderID(idp);
                idps.getIDPEntrys().add(entry);
            }
            scoping.setIDPList(idps);
            include = true;
        }
        SAMLObjectBuilder requesterIdBuilder = (SAMLObjectBuilder)bf.ensureBuilder(RequesterID.DEFAULT_ELEMENT_NAME);
        ProxiedRequesterContext proxiedReqCtx = this.proxiedRequesterContextLookupStrategy.apply(profileRequestContext);
        if (proxiedReqCtx != null) {
            for (String id : proxiedReqCtx.getRequesters()) {
                RequesterID requesterId = (RequesterID)requesterIdBuilder.buildObject();
                requesterId.setURI(id);
                scoping.getRequesterIDs().add(requesterId);
                include = true;
            }
        }
        if ((immediateRequester = this.requesterLookupStrategy.apply(profileRequestContext)) != null) {
            RequesterID requesterId = (RequesterID)requesterIdBuilder.buildObject();
            requesterId.setURI(immediateRequester);
            scoping.getRequesterIDs().add(requesterId);
            include = true;
        }
        return include ? scoping : null;
    }

    @Nullable
    private Extensions buildExtensions(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.profileConfiguration != null);
        Collection attrs = this.profileConfiguration.getRequestedAttributes(profileRequestContext);
        if (!attrs.isEmpty()) {
            XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
            SAMLObjectBuilder extBuilder = (SAMLObjectBuilder)bf.ensureBuilder(Extensions.DEFAULT_ELEMENT_NAME);
            SAMLObjectBuilder reqExtBuilder = (SAMLObjectBuilder)bf.ensureBuilder(RequestedAttributes.DEFAULT_ELEMENT_NAME);
            RequestedAttributes reqExt = (RequestedAttributes)reqExtBuilder.buildObject();
            attrs.forEach(attr -> {
                try {
                    assert (attr != null);
                    reqExt.getRequestedAttributes().add((RequestedAttribute)XMLObjectSupport.cloneXMLObject((XMLObject)attr));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("{} Error cloning RequestedAttribute from profile configuration", (Object)this.getLogPrefix(), (Object)e);
                }
            });
            Extensions ext = (Extensions)extBuilder.buildObject();
            ext.getUnknownXMLObjects().add(reqExt);
            return ext;
        }
        return null;
    }
}

