/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;

public class SAML2SPSessionCreationStrategy
implements Function<ProfileRequestContext, SPSession> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2SPSessionCreationStrategy.class);
    @Nonnull
    private final Duration sessionLifetime;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy;

    public SAML2SPSessionCreationStrategy(@Nonnull Duration lifetime) {
        this.sessionLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        Function rls = new MessageLookup(Response.class).compose((Function)new OutboundMessageContextLookup());
        assert (rls != null);
        this.responseLookupStrategy = rls;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public SPSession apply(@Nullable ProfileRequestContext input) {
        SubjectConfirmationData scData;
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(input);
        if (rpCtx == null) {
            this.log.debug("No RelyingPartyContext, no SAML2SPSession created");
            return null;
        }
        String issuer = rpCtx.getRelyingPartyId();
        if (issuer == null) {
            this.log.debug("No relying party ID, no SAML2SPSession created");
            return null;
        }
        assert (input != null);
        Pair<Assertion, AuthnStatement> result = this.getAssertionAndStatement(input);
        if (result == null) {
            this.log.info("Creating BasicSPSession in the absence of necessary information");
            Instant now = Instant.now();
            Instant then = now.plus(this.sessionLifetime);
            assert (then != null);
            return new BasicSPSession(issuer, now, then);
        }
        Instant now = Instant.now();
        Assertion first = (Assertion)result.getFirst();
        AuthnStatement second = (AuthnStatement)result.getSecond();
        assert (first != null && second != null);
        Instant sessionBound = second.getSessionNotOnOrAfter();
        Instant expiration = sessionBound != null ? sessionBound : now.plus(this.sessionLifetime);
        String acsLocation = null;
        Subject subject = first.getSubject();
        assert (subject != null);
        List sc = subject.getSubjectConfirmations();
        if (sc != null && !sc.isEmpty() && (scData = ((SubjectConfirmation)sc.get(0)).getSubjectConfirmationData()) != null) {
            acsLocation = scData.getRecipient();
        }
        boolean supportLogoutPropagation = false;
        BaseContext rpIdCtxTree = rpCtx.getRelyingPartyIdContextTree();
        if (rpIdCtxTree instanceof SAMLPeerEntityContext) {
            RoleDescriptor roleDescriptor;
            SAMLMetadataContext mdCtx = (SAMLMetadataContext)rpIdCtxTree.getSubcontext(SAMLMetadataContext.class);
            RoleDescriptor roleDescriptor2 = roleDescriptor = mdCtx != null ? mdCtx.getRoleDescriptor() : null;
            if (roleDescriptor != null && roleDescriptor instanceof SPSSODescriptor) {
                supportLogoutPropagation = !((SPSSODescriptor)roleDescriptor).getSingleLogoutServices().isEmpty();
            }
        }
        NameID nameID = subject.getNameID();
        String index = second.getSessionIndex();
        assert (nameID != null && index != null && now != null && expiration != null);
        return new SAML2SPSession(issuer, now, expiration, nameID, index, acsLocation, supportLogoutPropagation);
    }

    @Nullable
    private Pair<Assertion, AuthnStatement> getAssertionAndStatement(@Nonnull ProfileRequestContext profileRequestContext) {
        Response response = this.responseLookupStrategy.apply(profileRequestContext);
        if (response == null) {
            this.log.debug("No Response message or Assertions found");
            return null;
        }
        for (Assertion assertion : response.getAssertions()) {
            Subject subject = assertion.getSubject();
            if (subject == null || subject.getNameID() == null) continue;
            for (AuthnStatement statement : assertion.getAuthnStatements()) {
                if (statement.getSessionIndex() == null) continue;
                return new Pair((Object)assertion, (Object)statement);
            }
        }
        this.log.debug("No suitable Assertion/AuthnStatement found");
        return null;
    }
}

