/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ExtractActiveAuthenticationResults
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractActiveAuthenticationResults.class);
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextLookupStrategy = new ChildContextLookup(SessionContext.class);
    @NonnullBeforeExec
    private IdPSession session;

    public void setSessionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        this.checkSetterPreconditions();
        this.sessionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        SessionContext ctx = this.sessionContextLookupStrategy.apply(profileRequestContext);
        if (ctx != null) {
            this.session = ctx.getIdPSession();
            if (this.session != null) {
                return true;
            }
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (authenticationContext.getHintedName() == null) {
            authenticationContext.setHintedName(this.session.getPrincipalName());
        }
        Instant now = Instant.now();
        Duration maxAge = authenticationContext.getMaxAge();
        ArrayList<AuthenticationResult> actives = new ArrayList<AuthenticationResult>();
        for (AuthenticationResult result : this.session.getAuthenticationResults()) {
            AuthenticationFlowDescriptor descriptor = (AuthenticationFlowDescriptor)authenticationContext.getPotentialFlows().get(result.getAuthenticationFlowId());
            if (descriptor == null) {
                this.log.debug("{} Authentication result {} has no corresponding flow descriptor, considering inactive", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                continue;
            }
            if (descriptor.isResultActive(result)) {
                if (maxAge != null && result.getAuthenticationInstant().plus(maxAge).isBefore(now)) {
                    this.log.debug("{} Authentication result {} exceeds maxAge setting, skipping it", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                    continue;
                }
                this.log.debug("{} Authentication result {} is active, copying from session", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
                actives.add(result);
                continue;
            }
            this.log.debug("{} Authentication result {} is inactive, skipping it", (Object)this.getLogPrefix(), (Object)result.getAuthenticationFlowId());
        }
        if (actives.isEmpty()) {
            this.log.debug("{} No active authentication results, SSO will not be possible", (Object)this.getLogPrefix());
        }
        authenticationContext.setActiveResults(actives);
    }
}

