/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.profile.context.AuditContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SaveProfileRequestContextTree
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SaveProfileRequestContextTree.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextLookupStrategy = new ChildContextLookup(LogoutContext.class);

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        this.logoutContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuditContext auditCtx;
        LogoutContext logoutContext = this.logoutContextLookupStrategy.apply(profileRequestContext);
        if (logoutContext == null) {
            this.log.debug("{} LogoutContext not found in ProfileRequestContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((Object)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        MessageContext inbound = profileRequestContext.getInboundMessageContext();
        MessageContext outbound = profileRequestContext.getOutboundMessageContext();
        InOutOperationContext placeholder = new InOutOperationContext(inbound, outbound);
        logoutContext.addSubcontext((BaseContext)placeholder);
        profileRequestContext.setInboundMessageContext(null);
        profileRequestContext.setOutboundMessageContext(null);
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        if (relyingPartyCtx != null) {
            placeholder.addSubcontext((BaseContext)relyingPartyCtx);
        }
        if ((auditCtx = (AuditContext)profileRequestContext.getSubcontext(AuditContext.class)) != null) {
            placeholder.addSubcontext((BaseContext)auditCtx);
        }
        this.log.debug("{} Saved off LogoutRequest processing state during logout propagation", (Object)this.getLogPrefix());
    }
}

