/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DetectIdentitySwitch
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DetectIdentitySwitch.class);
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextLookupStrategy = new ChildContextLookup(SessionContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SubjectCanonicalizationContext> c14nContextLookupStrategy = new ChildContextLookup(SubjectCanonicalizationContext.class);
    @NonnullBeforeExec
    private SessionContext sessionCtx;
    @NonnullBeforeExec
    private String newPrincipalName;

    public void setSessionManager(@Nonnull SessionManager manager) {
        this.checkSetterPreconditions();
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSessionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        this.checkSetterPreconditions();
        this.sessionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup strategy cannot be null");
    }

    public void setSubjectCanonicalizationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectCanonicalizationContext> strategy) {
        this.checkSetterPreconditions();
        this.c14nContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectCanonicalizationContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.sessionManager == null) {
            throw new ComponentInitializationException("SessionManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.sessionCtx = this.sessionContextLookupStrategy.apply(profileRequestContext);
        SessionContext ctx = this.sessionCtx;
        if (ctx == null || ctx.getIdPSession() == null) {
            this.log.debug("{} No previous session found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        SubjectCanonicalizationContext c14n = this.c14nContextLookupStrategy.apply(profileRequestContext);
        if (c14n == null || c14n.getPrincipalName() == null) {
            this.log.debug("{} Reusing identity from session, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.newPrincipalName = c14n.getPrincipalName();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        IdPSession idpSession = this.sessionCtx.getIdPSession();
        assert (idpSession != null);
        if (idpSession.getPrincipalName().equals(this.newPrincipalName)) {
            this.log.debug("{} Identities from session and new authentication result match, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        this.log.info("{} Identity switch to {} detected, destroying original session {} for principal {}", new Object[]{this.getLogPrefix(), this.newPrincipalName, idpSession.getId(), idpSession.getPrincipalName()});
        try {
            String id = idpSession.getId();
            assert (id != null);
            this.sessionManager.destroySession(id, true);
        }
        catch (SessionException e) {
            this.log.error("{} Error destroying session {}", new Object[]{this.getLogPrefix(), idpSession.getId(), e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
        this.sessionCtx.setIdPSession(null);
        authenticationContext.setActiveResults((Iterable)CollectionSupport.emptyList());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"IdentitySwitch");
    }
}

