/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ProcessLogout
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessLogout.class);
    @NonnullAfterInit
    private SessionResolver sessionResolver;
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextCreationStrategy = new ChildContextLookup(SubjectContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextCreationStrategy = new ChildContextLookup(LogoutContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, CriteriaSet> sessionResolverCriteriaStrategy = prc -> new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()});
    @Nullable
    private Function<ProfileRequestContext, String> addressLookupStrategy;

    public void setSessionResolver(@Nonnull SessionResolver resolver) {
        this.checkSetterPreconditions();
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
    }

    public void setSubjectContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.subjectContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext creation strategy cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        this.checkSetterPreconditions();
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext creation strategy cannot be null");
    }

    public void setLogoutContextCreationStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        this.checkSetterPreconditions();
        this.logoutContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext creation strategy cannot be null");
    }

    public void setSessionResolverCriteriaStrategy(@Nonnull Function<ProfileRequestContext, CriteriaSet> strategy) {
        this.sessionResolverCriteriaStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionResolver CriteriaSet strategy cannot be null");
    }

    public void setAddressLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.addressLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!PredicateSupport.isAlwaysFalse((Predicate)this.getActivationCondition()) && this.sessionResolver == null) {
            throw new ComponentInitializationException("SessionResolver cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            LogoutContext logoutCtx;
            SessionContext sessionCtx;
            IdPSession session;
            block13: {
                session = (IdPSession)this.sessionResolver.resolveSingle((Object)this.sessionResolverCriteriaStrategy.apply(profileRequestContext));
                if (session == null) {
                    this.log.info("{} No active session found matching current request", (Object)this.getLogPrefix());
                    return;
                }
                String addr = null;
                if (this.addressLookupStrategy != null) {
                    addr = this.addressLookupStrategy.apply(profileRequestContext);
                } else {
                    HttpServletRequest request = this.getHttpServletRequest();
                    String string = addr = request != null ? HttpServletSupport.getRemoteAddr((ServletRequest)request) : null;
                }
                if (addr != null) {
                    try {
                        if (!session.checkAddress(addr)) {
                            return;
                        }
                        break block13;
                    }
                    catch (SessionException e) {
                        this.log.error("{} Error validating session against client address", (Object)this.getLogPrefix(), (Object)e);
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
                        return;
                    }
                }
                this.log.info("{} No client address available, skipping address check for session", (Object)this.getLogPrefix());
            }
            SubjectContext subjectCtx = this.subjectContextCreationStrategy.apply(profileRequestContext);
            if (subjectCtx != null) {
                subjectCtx.setPrincipalName(session.getPrincipalName());
            }
            if ((sessionCtx = this.sessionContextCreationStrategy.apply(profileRequestContext)) != null) {
                sessionCtx.setIdPSession(session);
            }
            if ((logoutCtx = this.logoutContextCreationStrategy.apply(profileRequestContext)) == null) {
                this.log.error("{} Unable to create or locate LogoutContext", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
            logoutCtx.getIdPSessions().add(session);
            int count = 1;
            for (SPSession spSession : session.getSPSessions()) {
                logoutCtx.getSessionMap().put((Object)spSession.getId(), (Object)spSession);
                logoutCtx.getKeyedSessionMap().put(Integer.toString(count++), spSession);
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving matching session(s)", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }
}

