/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.oidc.op.audit;

import javax.annotation.Nonnull;

import net.shibboleth.idp.profile.context.AuditContext;
import net.shibboleth.idp.saml.profile.SAMLAuditFields;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

/** Constants to use for audit logging fields stored in an {@link AuditContext}. */
public final class AuditFields {
    
    /** OIDC client ID. */
    @Nonnull @NotEmpty public static final String CLIENT_ID = SAMLAuditFields.SERVICE_PROVIDER;
    
    /** OIDC issuer. */
    @Nonnull @NotEmpty public static final String ISSUER = SAMLAuditFields.IDENTITY_PROVIDER;

    /** The inbound (Nimbus) message class. */
    @Nonnull @NotEmpty public static final String INBOUND_MESSAGE_CLASS = SAMLAuditFields.REQUEST_BINDING;
    
    /** The outbound (Nimbus) message class. */
    @Nonnull @NotEmpty public static final String OUTBOUND_MESSAGE_CLASS = SAMLAuditFields.RESPONSE_BINDING;
    
    /** The authentication context reference value. */
    @Nonnull @NotEmpty public static final String ACR = SAMLAuditFields.AUTHN_CONTEXT;

    /** The subject value. */
    @Nonnull @NotEmpty public static final String SUB_VALUE = SAMLAuditFields.NAMEID;
    
    /** The subject format (public/pairwise). */
    @Nonnull @NotEmpty public static final String SUB_FORMAT = SAMLAuditFields.NAMEID_FORMAT;

    /** The flag whether the id_token is encrypted. */
    @Nonnull @NotEmpty public static final String ENCRYPTED_ID_TOKEN = SAMLAuditFields.ENCRYPTION;

    /** prompt=none requested field. */
    @Nonnull @NotEmpty public static final String IS_PASSIVE = SAMLAuditFields.IS_PASSIVE;

    /** prompt=login requested field. */
    @Nonnull @NotEmpty public static final String FORCE_AUTHN = SAMLAuditFields.FORCE_AUTHN;
    
    /** auth_time value. */
    @Nonnull @NotEmpty public static final String AUTHN_INSTANT = SAMLAuditFields.AUTHN_INSTANT;
    
    /** id_token issue instant. */
    @Nonnull @NotEmpty public static final String ID_TOKEN_ISSUE_INSTANT = SAMLAuditFields.ASSERTION_ISSUE_INSTANT;

    /** id_token nonce. */
    @Nonnull @NotEmpty public static final String NONCE = SAMLAuditFields.RELAY_STATE;

    /** Revoked Token. */
    @Nonnull @NotEmpty public static final String REVOKED_TOKEN = "R";
    
    /**
     * Constructor.
     */
    private AuditFields() {
        // no op
    }

}
