/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import java.time.Instant;

import javax.annotation.Nullable;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;

/**
 * A function that returns auth time via a lookup function. This lookup locates auth time from authentication context.
 * If auth time is not available, null is returned.
 */
public class DefaultAuthTimeLookupFunction implements ContextDataLookupFunction<ProfileRequestContext,Instant> {

    /** {@inheritDoc} */
    @Nullable
    public Instant apply(@Nullable final ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        final AuthenticationContext authCtx = input.getSubcontext(AuthenticationContext.class, false);
        if (authCtx == null) {
            return null;
        }
        final AuthenticationResult authResult = authCtx.getAuthenticationResult();
        if (authResult == null) {
            return null;
        }
        return authResult.getAuthenticationInstant();

    }

}