/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import java.util.List;

import com.nimbusds.oauth2.sdk.TokenRequest;

/**
 * For Token endpoint.
 * 
 * A function that returns code verifier value of the token request via a lookup function. This default lookup locates
 * code verifier from request if available. If information is not available, null is returned.
 */
public class DefaultRequestCodeVerifierLookupFunction extends AbstractTokenRequestLookupFunction<String> {

    /** {@inheritDoc} */
    @Override
    String doLookup(final TokenRequest req) {
        final List<String> verifier = req.getAuthorizationGrant().toParameters().get("code_verifier");
        return verifier == null ? null : verifier.get(0);
    }
}