/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCAuthenticationResponseContextTest {
    private OIDCAuthenticationResponseContext ctx;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.ctx = new OIDCAuthenticationResponseContext();
    }

    @Test
    public void testInitialState() {
        Assert.assertNull((Object)this.ctx.getRequestedSubject());
        Assert.assertNull((Object)this.ctx.getAcr());
        Assert.assertNull((Object)this.ctx.getAuthTime());
        Assert.assertNull((Object)this.ctx.getIDToken());
        Assert.assertNull((Object)this.ctx.getSubject());
        Assert.assertNull((Object)this.ctx.getRedirectURI());
        Assert.assertNull((Object)this.ctx.getScope());
        Assert.assertNull((Object)this.ctx.getProcessedToken());
        Assert.assertNull((Object)this.ctx.getRequestedClaims());
        Assert.assertNull((Object)this.ctx.getTokenClaimsSet());
        Assert.assertNull((Object)this.ctx.getAuthorizationCode());
        Assert.assertNull((Object)this.ctx.getAccessToken());
        Assert.assertNull((Object)this.ctx.getRefreshToken());
        Assert.assertNull((Object)this.ctx.getSubjectType());
        Assert.assertNull((Object)this.ctx.getUserInfo());
    }

    @Test
    public void testSetters() throws URISyntaxException, ParseException {
        this.ctx.setAcr("acrValue");
        this.ctx.setAuthTime(Instant.ofEpochMilli(1L));
        Issuer issuer = new Issuer("iss");
        Subject sub = new Subject("sub");
        ArrayList<Audience> aud = new ArrayList<Audience>();
        aud.add(new Audience("aud"));
        IDTokenClaimsSet token = new IDTokenClaimsSet(issuer, sub, aud, new Date(), new Date());
        this.ctx.setIDToken(token);
        this.ctx.setSubject("sub");
        URI uri = new URI("https://example.org");
        this.ctx.setRedirectURI(uri);
        this.ctx.setRequestedSubject("sub");
        Scope scope = new Scope();
        this.ctx.setScope(scope);
        JWSHeader header = new JWSHeader(JWSAlgorithm.ES256);
        SignedJWT sJWT = new SignedJWT(header, token.toJWTClaimsSet());
        this.ctx.setProcessedToken((JWT)sJWT);
        Assert.assertEquals((String)this.ctx.getAcr().toString(), (String)"acrValue");
        this.ctx.setAcr(null);
        OIDCClaimsRequest claims = new OIDCClaimsRequest();
        this.ctx.setRequestedClaims(claims);
        this.ctx.setSubjectType("pairwise");
        UserInfo info = new UserInfo(sub);
        this.ctx.setUserInfo(info);
        Assert.assertNull((Object)this.ctx.getAcr());
        Assert.assertEquals((Object)this.ctx.getAuthTime(), (Object)Instant.ofEpochMilli(1L));
        Assert.assertEquals((Object)this.ctx.getIDToken(), (Object)token);
        Assert.assertEquals((String)this.ctx.getSubject(), (String)"sub");
        Assert.assertEquals((Object)this.ctx.getProcessedToken(), (Object)sJWT);
        Assert.assertEquals((Object)this.ctx.getRedirectURI(), (Object)uri);
        Assert.assertEquals((String)this.ctx.getRequestedSubject(), (String)"sub");
        Assert.assertEquals((Set)this.ctx.getScope(), (Set)scope);
        Assert.assertEquals((Object)claims, (Object)this.ctx.getRequestedClaims());
        Assert.assertEquals((String)"pairwise", (String)this.ctx.getSubjectType());
        Assert.assertEquals((Object)info, (Object)this.ctx.getUserInfo());
    }
}

