/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.resolver;

import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.ProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.RefreshableProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.ServiceableProviderMetadataProvider;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ServiceableProviderMetadataProviderTest {
    ServiceableProviderMetadataProvider provider;
    Instant lastRefresh;
    Instant lastUpdate;

    @BeforeMethod
    public void setup() {
        this.provider = new ServiceableProviderMetadataProvider();
        this.provider.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.lastRefresh = Instant.now();
        this.lastUpdate = Instant.now().minus(Duration.ofHours(1L));
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoId() throws ComponentInitializationException {
        this.provider.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoResolver() throws ComponentInitializationException {
        this.provider.setId("mockId");
        this.provider.initialize();
    }

    @Test
    public void testEquals() throws ResolverException, URISyntaxException, ComponentInitializationException {
        int sortKey = 1234;
        this.provider.setId("mockId");
        this.provider.setEmbeddedResolver(this.buildMetadataResolver("mock1", "mock2"));
        this.provider.setSortKey(sortKey);
        this.provider.initialize();
        ServiceableProviderMetadataProvider provider2 = new ServiceableProviderMetadataProvider();
        provider2.setId("mockId");
        provider2.setApplicationContext(this.provider.getApplicationContext());
        provider2.setEmbeddedResolver(this.buildMetadataResolver("mock1", "mock2"));
        provider2.setSortKey(sortKey);
        provider2.initialize();
        ServiceableProviderMetadataProvider provider3 = new ServiceableProviderMetadataProvider();
        provider3.setId("mockId");
        provider3.setApplicationContext(this.provider.getApplicationContext());
        provider3.setEmbeddedResolver(this.buildMetadataResolver("mock1", "mock2"));
        provider3.setSortKey(sortKey + 1);
        provider3.initialize();
        Assert.assertTrue((boolean)this.provider.equals((Object)provider2));
        Assert.assertFalse((boolean)this.provider.equals((Object)provider3));
    }

    @Test
    public void testResolver() throws ComponentInitializationException, ResolverException, URISyntaxException {
        this.provider.setId("mockId");
        this.provider.setEmbeddedResolver(this.buildMetadataResolver("mock1", "mock2"));
        this.provider.initialize();
        Iterable iterable = this.provider.resolve(null);
        Iterator iterator = iterable.iterator();
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)iterator.next();
        Assert.assertTrue((metadata.getIssuer().getValue().equals("mock1") || metadata.getIssuer().getValue().equals("mock2") ? 1 : 0) != 0);
        metadata = (OIDCProviderMetadata)iterator.next();
        Assert.assertTrue((metadata.getIssuer().getValue().equals("mock1") || metadata.getIssuer().getValue().equals("mock2") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((String)"mock1", (String)this.provider.resolveSingle(null).getIssuer().getValue());
    }

    @Test
    public void testLastUpdateAndRefresh() throws ResolverException, URISyntaxException, ComponentInitializationException {
        this.provider.setId("mockId");
        this.provider.setEmbeddedResolver(this.buildMetadataResolver("mock1", "mock2"));
        this.provider.initialize();
        Assert.assertEquals((Object)this.lastUpdate, (Object)this.provider.getLastUpdate());
        Assert.assertEquals((Object)this.lastRefresh, (Object)this.provider.getLastRefresh());
    }

    protected ProviderMetadataResolver buildMetadataResolver(String ... names) throws ResolverException, URISyntaxException {
        RefreshableProviderMetadataResolver resolver = (RefreshableProviderMetadataResolver)Mockito.mock(RefreshableProviderMetadataResolver.class);
        Mockito.when((Object)resolver.resolve((Object)((ProfileRequestContext)Mockito.any()))).thenReturn(this.createMetadataList(names));
        Mockito.when((Object)((OIDCProviderMetadata)resolver.resolveSingle((Object)((ProfileRequestContext)Mockito.any())))).thenReturn((Object)this.createMetadata(names[0]));
        Mockito.when((Object)resolver.getLastRefresh()).thenReturn((Object)this.lastRefresh);
        Mockito.when((Object)resolver.getLastUpdate()).thenReturn((Object)this.lastUpdate);
        return resolver;
    }

    protected ProviderMetadataResolver buildMetadataResolver(boolean refreshable, String ... names) throws ResolverException, URISyntaxException {
        RefreshableProviderMetadataResolver resolver = (RefreshableProviderMetadataResolver)Mockito.mock(RefreshableProviderMetadataResolver.class);
        Mockito.when((Object)resolver.resolve((Object)((ProfileRequestContext)Mockito.any()))).thenReturn(this.createMetadataList(names));
        Mockito.when((Object)((OIDCProviderMetadata)resolver.resolveSingle((Object)((ProfileRequestContext)Mockito.any())))).thenReturn((Object)this.createMetadata(names[0]));
        Mockito.when((Object)resolver.getLastRefresh()).thenReturn((Object)this.lastRefresh);
        Mockito.when((Object)resolver.getLastUpdate()).thenReturn((Object)this.lastUpdate);
        return resolver;
    }

    protected List<OIDCProviderMetadata> createMetadataList(String ... names) throws URISyntaxException {
        ArrayList<OIDCProviderMetadata> list = new ArrayList<OIDCProviderMetadata>();
        for (String name : names) {
            list.add(this.createMetadata(name));
        }
        return list;
    }

    protected OIDCProviderMetadata createMetadata(String name) throws URISyntaxException {
        Issuer issuer = new Issuer(name);
        return new OIDCProviderMetadata(issuer, Arrays.asList(SubjectType.PUBLIC), new URI("http://example.org"));
    }
}

